#ifndef ETPAN_STORAGE_H

#define ETPAN_STORAGE_H

#include "etpan-storage-types.h"
#include "etpan-folder-types.h"
#include "etpan-thread-manager-app-types.h"

struct etpan_storage * etpan_storage_new(void);
void etpan_storage_free(struct etpan_storage * storage);

void etpan_storage_set_data(struct etpan_storage * storage, void * data);
void * etpan_storage_get_data(struct etpan_storage * storage);

void etpan_storage_set_driver(struct etpan_storage * storage,
    struct etpan_storage_driver * driver);

struct etpan_storage_driver *
etpan_storage_get_driver(struct etpan_storage * storage);

void etpan_storage_set_account(struct etpan_storage * storage,
    struct etpan_account * account);
struct etpan_account *
etpan_storage_get_account(struct etpan_storage * storage);

void etpan_storage_set_id(struct etpan_storage * storage, char * id);
char * etpan_storage_get_id(struct etpan_storage * storage);

struct etpan_thread_op *
etpan_storage_fetch_folder_list(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    void (* callback)(int, struct etpan_storage_fetch_folder_list_result *,
        void *),
    void * cb_data);

struct etpan_thread_op *
etpan_storage_disconnect(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    void (* callback)(int, void * /* dummy argument */,
        void *),
    void * cb_data);

void etpan_storage_clear_folder_list(struct etpan_storage * storage);

struct etpan_thread_op *
etpan_storage_create_folder(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    char * location,
    void (* callback)(int, struct etpan_storage_create_folder_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_storage_delete_folder(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    char * location,
    void (* callback)(int, struct etpan_storage_delete_folder_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_storage_rename_folder(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    char * location, char * new_location,
    void (* callback)(int, struct etpan_storage_rename_folder_result *, void *),
    void * cb_data);

int etpan_storage_has_folder_list(struct etpan_storage * storage);

chash * etpan_storage_get_folder_list(struct etpan_storage * storage);

struct etpan_error *
etpan_storage_update_folder_list(struct etpan_storage * storage,
    chash * folder_list) WARN_UNUSED_RESULT;

void etpan_storage_remove_lost_folders(struct etpan_storage * storage);

void etpan_storage_remove_folder(struct etpan_storage * storage,
    struct etpan_folder * folder);

struct etpan_folder * etpan_storage_get_folder(struct etpan_storage * storage,
    char * name);

struct etpan_error *
etpan_storage_setup(struct etpan_storage * storage) WARN_UNUSED_RESULT;
void etpan_storage_unsetup(struct etpan_storage * storage);

void etpan_storage_set_cache_path(struct etpan_storage * storage,
    char * cache_path);
char * etpan_storage_get_cache_path(struct etpan_storage * storage);

void etpan_storage_set_flags_path(struct etpan_storage * storage,
    char * flags_path);
char * etpan_storage_get_flags_path(struct etpan_storage * storage);

char * etpan_storage_get_sub_folder_location(struct etpan_storage * storage,
    struct etpan_folder * parent, char * name);

int etpan_storage_allows_sub_folders(struct etpan_storage * storage,
    struct etpan_folder * parent);

#endif
