#include "etpan-text-quote.h"

#include <stdlib.h>
#include <string.h>
#include <libetpan/libetpan.h>

#include "etpan-text-wrapper.h"
#include "etpan-error.h"
#include "etpan-log.h"

static void quote_text(char * input, size_t input_size,
    char ** p_output, size_t * p_output_size)
{
  MMAPString * str;
  char * output;
  int col;
  char * p;
  char * current_line;
  size_t size;
  size_t offset;
  
  str = mmap_string_new("");
  if (str == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  col = 0;
  p = input;
  current_line = p;
  
  while ((size_t) (p - input) < input_size) {
    int got_line;
    
    got_line = 0;
    /* look for next LF */
    while ((size_t) (p - input) < input_size) {
      if (* p == '\n') {
        got_line = 1;
        break;
      }
      p ++;
    }
    if (got_line) {
      p ++;
      if (mmap_string_append(str, "> ") == NULL)
        ETPAN_LOG_MEMORY_ERROR;
      if (mmap_string_append_len(str, current_line, p - current_line) == NULL)
        ETPAN_LOG_MEMORY_ERROR;
      current_line = p;
    }
    else {
      p ++;
    }
  }
  
  offset = current_line - input;
  size = input_size - offset;
  if (size != 0) {
    if (mmap_string_append(str, "> ") == NULL)
      ETPAN_LOG_MEMORY_ERROR;
    if (mmap_string_append_len(str, current_line, size) == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  }
  
  /* return the result */
  output = malloc(str->len + 1);
  if (output == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  strncpy(output, str->str, str->len);
  output[str->len] = '\0';
  
  * p_output = output;
  * p_output_size = str->len;
  
  mmap_string_free(str);
}

#define WRAP_COUNT 72

void etpan_quote_text(char * input, size_t input_size,
    char ** p_output, size_t * p_output_size)
{
  char * wrapped;
  size_t wrapped_size;
  char * unwrapped;
  size_t unwrapped_size;
  
  etpan_unwrap_text(input, input_size, &unwrapped, &unwrapped_size);
  
  etpan_wrap_text(unwrapped, unwrapped_size,
      &wrapped, &wrapped_size, WRAP_COUNT);
  
  free(unwrapped);
  
  quote_text(wrapped, wrapped_size, p_output, p_output_size);
  
  free(wrapped);
}
