#include "etpan-text-wrapper.h"

#include <libetpan/libetpan.h>
#include <stdlib.h>
#include <string.h>

#include "etpan-error.h"
#include "etpan-log.h"

static inline int is_word_sep(char c)
{
  unsigned char value;
  
  value = c;
  
  if ((value >= ' ') && (value <= '/'))
    return 1;
  else
    return 0;
}

#if 0
static inline int get_quote_length(char * input, size_t input_size)
{
  size_t remaining;
  char * p;
  int count;
  
  count = 0;
  remaining = input_size;
  p = input;
  while (remaining > 0) {
    if (* p == '>')
      count ++;
    else
      return count;
    
    p ++;
    remaining --;
  }
  
  return count;
}
#endif

void etpan_wrap_text(char * input, size_t input_size,
    char ** p_output, size_t * p_output_size, int columns)
{
  MMAPString * str;
  char * output;
  int col;
  char * p;
  char * current_line;
  char * last_word;
  size_t size;
  size_t offset;
  
  str = mmap_string_new("");
  if (str == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  /* compute the wrapping */
  
  col = 0;
  p = input;
  current_line = p;
  last_word = p;
  
  while ((size_t) (p - input) < input_size) {
    if ((current_line == p) && (* p == '>')) {
      int got_line;
      
      got_line = 0;
      /* look for next LF */
      while ((size_t) (p - input) < input_size) {
        if (* p == '\n') {
          got_line = 1;
          break;
        }
        p ++;
      }
      if (got_line) {
        p ++;
        mmap_string_append_len(str, current_line, p - current_line);
        current_line = p;
      }
      else {
        p ++;
      }
    }
    else {
      size = last_word - current_line;
      if (* p == '\n') {
        size = p - current_line + 1;
        if (mmap_string_append_len(str, current_line, size) == NULL)
          ETPAN_LOG_MEMORY_ERROR;
        
        /* next line */
        p ++;
        offset = p - input;
        size = input_size - offset;
        
        current_line = p;
        last_word = p;
      }
      else {
        if ((p - current_line + 1 >= columns) && /* (size > 0) */((last_word - current_line) > 0)) {
          if (mmap_string_append_len(str, current_line, size) == NULL)
            ETPAN_LOG_MEMORY_ERROR;
          if (mmap_string_append(str, " \n") == NULL)
            ETPAN_LOG_MEMORY_ERROR;
          
          current_line = last_word;
        }
        
        if (is_word_sep(* p))
          last_word = p + 1;
        
        p ++;
      }
    }
  }
  
  offset = current_line - input;
  size = input_size - offset;
  mmap_string_append_len(str, current_line, size);  
  
  /* return the result */
  output = malloc(str->len + 1);
  if (output == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  strncpy(output, str->str, str->len);
  output[str->len] = '\0';
  
  * p_output = output;
  * p_output_size = str->len;
  
  mmap_string_free(str);
}


void etpan_unwrap_text(char * input, size_t input_size,
    char ** p_output, size_t * p_output_size)
{
  MMAPString * str;
  char * output;
  int col;
  char * p;
  char * current_line;
  size_t size;
  size_t offset;
  
  str = mmap_string_new("");
  if (str == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  /* compute the unwrapping */
  
  col = 0;
  p = input;
  current_line = p;
  
  while ((size_t) (p - input) < input_size) {
    if ((current_line == p) && (* p == '>')) {
      int got_line;
      
      got_line = 0;
      /* look for next LF */
      while ((size_t) (p - input) < input_size) {
        if (* p == '\n') {
          got_line = 1;
          break;
        }
        p ++;
      }
      if (got_line) {
        p ++;
        if (mmap_string_append_len(str, current_line, p - current_line) == NULL)
          ETPAN_LOG_MEMORY_ERROR;
        current_line = p;
      }
      else {
        p ++;
      }
    }
    else {
      int got_line;
      int had_space;
      char * line_end;
      
      line_end = NULL;
      had_space = 0;
      got_line = 0;
      /* look for next LF */
      while ((size_t) (p - input) < input_size) {
        if (* p == '\r') {
          line_end = p;
        }
        else if (* p == ' ') {
          had_space = 1;
        }
        else {
          if (* p == '\n') {
            if (line_end == NULL)
              line_end = p;
            got_line = 1;
            break;
          }
          had_space = 0;
        }
        p ++;
      }
      if (got_line) {
        p ++;
        
        if (str->len != 0) {
          char ch;
          
          ch = str->str[str->len - 1];
          
          if ((ch != ' ') && (ch != '\n') && (ch != '\t')) {
            if (mmap_string_append_c(str, ' ') == NULL)
              ETPAN_LOG_MEMORY_ERROR;
          }
        }
        
        if (had_space && ((line_end - current_line) == 3)) {
          if (strncasecmp(current_line, "-- ", 3) == 0)
            had_space = 0;
        }
        
        if (had_space) {
          if (mmap_string_append_len(str, current_line,
              line_end - 1 - current_line) == NULL)
            ETPAN_LOG_MEMORY_ERROR;
        }
        else {
          if (mmap_string_append_len(str, current_line,
                  p - current_line) == NULL)
            ETPAN_LOG_MEMORY_ERROR;
        }
        current_line = p;
      }
      else {
        p ++;
      }
    }
  }
  
  offset = current_line - input;
  size = input_size - offset;
  if (mmap_string_append_len(str, current_line, size) == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  /* return the result */
  output = malloc(str->len + 1);
  if (output == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  strncpy(output, str->str, str->len);
  output[str->len] = '\0';
  
  * p_output = output;
  * p_output_size = str->len;
  
  mmap_string_free(str);
}
