#ifndef ETPAN_THREAD_MANAGER_APP_H

#define ETPAN_THREAD_MANAGER_APP_H

#include "etpan-thread-manager-app-types.h"

#include "etpan-thread-manager.h"
#include "etpan-sender-types.h"
#include "etpan-storage-types.h"
#include "etpan-abook-types.h"

struct etpan_thread_manager_app * etpan_thread_manager_app_new(void);
void etpan_thread_manager_app_free(struct etpan_thread_manager_app * manager);

/* start / stop */

void etpan_thread_manager_app_start(struct etpan_thread_manager_app * manager);

void etpan_thread_manager_app_stop(struct etpan_thread_manager_app *
    manager_app, void (* callback)(void *), void * cb_data);

int etpan_thread_manager_app_is_stopped(struct etpan_thread_manager_app *
    manager);
void etpan_thread_manager_app_join(struct etpan_thread_manager_app * manager);

int etpan_thread_manager_app_get_fd(struct etpan_thread_manager_app * manager);
void etpan_thread_manager_app_loop(struct etpan_thread_manager_app * manager);

/* particular threads */

struct etpan_thread *
etpan_thread_manager_app_get_storage_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_storage * storage);

struct etpan_thread *
etpan_thread_manager_app_get_sender_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_sender * sender);

struct etpan_thread *
etpan_thread_manager_app_get_abook_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_abook * abook);


void etpan_thread_manager_app_unbind_storage_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_storage * storage);

void etpan_thread_manager_app_unbind_sender_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_sender * sender);

void etpan_thread_manager_app_unbind_abook_thread(struct etpan_thread_manager_app *
    manager_app, struct etpan_abook * abook);

/* manager op */

void etpan_thread_manager_app_misc_schedule(struct etpan_thread_manager_app *
    manager_app, struct etpan_thread_op * op);

void etpan_thread_manager_app_storage_schedule(struct etpan_thread_manager_app *
    manager_app, struct etpan_storage * storage,
    struct etpan_thread_op * op);

void etpan_thread_manager_app_sender_schedule(struct etpan_thread_manager_app *
    manager_app, struct etpan_sender * sender,
    struct etpan_thread_op * op);

void etpan_thread_manager_app_abook_schedule(struct etpan_thread_manager_app *
    manager_app, struct etpan_abook * abook,
    struct etpan_thread_op * op);

void etpan_thread_manager_app_set_default(struct etpan_thread_manager_app *
    manager_app);
struct etpan_thread_manager_app * etpan_thread_manager_app_get_default(void);

/* main thread */
void etpan_thread_manager_app_run_in_main_thread(struct etpan_thread_manager_app * manager_app, void (* f)(void *), void * data, int wait);

#endif
