/**
 * uri.c: library of generic URI related routines 
 *
 * Reference: RFC 2396
 *
 * See Copyright for the status of this software.
 *
 * Daniel.Veillard@w3.org
 * adapted by DINH Viet Hoa for etpanX
 */

#ifndef ETPAN_URI_H__
#define ETPAN_URI_H__

#include "etpan-uri-types.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * This function is in tree.h:
 * xmlChar *    xmlNodeGetBase        (xmlDocPtr doc,
 *                               xmlNodePtr cur);
 */
struct etpan_uri * etpan_uri_new(void);
void etpan_uri_reset(struct etpan_uri * uri);
void etpan_uri_free(struct etpan_uri * uri);

char * etpan_uri_build(const char * uri, const char * base);
struct etpan_uri * etpan_uri_parse(const char * uri);
int etpan_uri_parse_reference(struct etpan_uri * uri, const char * str);
char * etpan_uri_render(struct etpan_uri * uri);
void etpan_uri_print(FILE * stream, struct etpan_uri * uri);
char * etpan_uri_unescape(const char * str);
void etpan_uri_normalize_path(char * path);
char * etpan_uri_escape(const char * str);

char * etpan_uri_get_scheme(struct etpan_uri * uri);
void etpan_uri_set_scheme(struct etpan_uri * uri, const char * scheme);

char * etpan_uri_get_opaque(struct etpan_uri * uri);
void etpan_uri_set_opaque(struct etpan_uri * uri, const char * opaque);

char * etpan_uri_get_authority(struct etpan_uri * uri);
void etpan_uri_set_authority(struct etpan_uri * uri, const char * authority);

char * etpan_uri_get_server(struct etpan_uri * uri);
void etpan_uri_set_server(struct etpan_uri * uri, const char * server);

char * etpan_uri_get_user(struct etpan_uri * uri);
void etpan_uri_set_user(struct etpan_uri * uri, const char * user);

int etpan_uri_get_port(struct etpan_uri * uri);
void etpan_uri_set_port(struct etpan_uri * uri, int port);

char * etpan_uri_get_path(struct etpan_uri * uri);
void etpan_uri_set_path(struct etpan_uri * uri, const char * path);

char * etpan_uri_get_query(struct etpan_uri * uri);
void etpan_uri_set_query(struct etpan_uri * uri, const char * query);

char * etpan_uri_get_fragment(struct etpan_uri * uri);
void etpan_uri_set_fragment(struct etpan_uri * uri, const char * fragment);

void etpan_uri_log(struct etpan_uri * uri);

#ifdef __cplusplus
}
#endif
#endif /* ETPAN_URI_H__ */
