#ifndef ETPAN_UTILS_H

#define ETPAN_UTILS_H

#include <sys/types.h>
#include <stdio.h>

#include "etpan-account-types.h"
#include "etpan-account-manager-types.h"
#include "etpan-imap-sync-types.h"
#include "etpan-pop-sync-types.h"

void etpan_set_tmp_dir(char * tmp);
char * etpan_get_tmp_dir(void);

int etpan_get_tmp_fd(char * tmp_file, size_t size);
FILE * etpan_get_tmp_file(char * tmp_file, size_t size);
int etpan_get_tmp_filename(char * tmp_file, size_t size);

int etpan_make_dir(char * path);

int etpan_get_tmp_path(char * tmp_path, size_t size);

int etpan_quote_filename(char * result, size_t size, char * path);

int etpan_file_exists(char * filename);

int etpan_write_file(char * filename, void * data, size_t length);

char * etpan_get_flags_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_cache_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_index_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_filter_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_outbox_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_outbox_news_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_outbox_sent_folder_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_outbox_cache_dir(struct etpan_account_manager * manager,
    struct etpan_outbox * outbox);

char * etpan_get_outbox_flags_dir(struct etpan_account_manager * manager,
    struct etpan_outbox * outbox);

char * etpan_get_order_dir(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_get_uuid_filename(struct etpan_account_manager * manager,
    struct etpan_account * account);

char * etpan_quote_mailbox(const char * mb);

char * etpan_get_imap_cache_dir(struct etpan_account_manager * manager,
    struct etpan_imap_sync * imap_sync);

char * etpan_get_pop_cache_dir(struct etpan_account_manager * manager,
    struct etpan_pop_sync * pop_sync);

#endif
