#ifndef ETPAN_ABOOK_MANAGER_H

#define ETPAN_ABOOK_MANAGER_H

#include "etpan-abook-manager-types.h"

struct etpan_abook_manager * etpan_abook_manager_new(void);

void etpan_abook_manager_free(struct etpan_abook_manager * manager);

chash * etpan_abook_manager_get_abook_hash(struct etpan_abook_manager *
    manager);

struct etpan_abook *
etpan_abook_manager_get_abook(struct etpan_abook_manager * manager,
    char * name);

void etpan_abook_manager_add_abook(struct etpan_abook_manager * manager,
    struct etpan_abook * abook);

void etpan_abook_manager_remove_abook(struct etpan_abook_manager *
    manager, struct etpan_abook * abook);

void etpan_abook_manager_set_default(struct etpan_abook_manager * manager);
struct etpan_abook_manager * etpan_abook_manager_get_default(void);

carray * etpan_abook_manager_get_ordered_list(struct etpan_abook_manager * manager);

void etpan_abook_manager_notify_modification(struct etpan_abook_manager * manager);

void etpan_abook_manager_stop(struct etpan_abook_manager * manager,
    void (* callback)(void *), void * cb_data);

void etpan_abook_manager_setup(struct etpan_abook_manager * manager);

void etpan_abook_manager_unsetup(struct etpan_abook_manager * manager);

#endif
