#ifndef ETPAN_ABOOK_TYPES_H

#define ETPAN_ABOOK_TYPES_H

#include <libetpan/libetpan.h>

struct etpan_abook;

struct etpan_abook_driver {
  char * name;
  int network;
  
  struct etpan_error * (* setup)(struct etpan_abook * abook);
  void (* free_data)(struct etpan_abook * abook);
  
  struct etpan_error * (* connect)(struct etpan_abook * abook);
  void (* disconnect)(struct etpan_abook * abook);
  
  struct etpan_error * (* lookup)(struct etpan_abook * abook,
      const char * key, carray * result);
};

struct etpan_abook {
  char * id;
  struct etpan_abook_driver * driver;
  void * data;
};

struct etpan_abook_entry {
  char * firstname;
  char * fullname;
  char * lastname;
  char * address;
  char * nickname;
  int match_type;
};

struct etpan_abook_lookup_result {
  struct etpan_error * error;
  carray * entry_list;
};

enum {
  ETPAN_ABOOK_MATCH_NONE = 0,
  ETPAN_ABOOK_MATCH_FULLNAME,
  ETPAN_ABOOK_MATCH_ADDRESS,
  ETPAN_ABOOK_MATCH_FIRSTNAME,
  ETPAN_ABOOK_MATCH_LASTNAME,
  ETPAN_ABOOK_MATCH_NICKNAME,
};

#endif
