#ifndef ETPAN_ABOOK_H

#define ETPAN_ABOOK_H

#include "etpan-abook-types.h"
#include "etpan-thread-manager-app-types.h"
#include "etpan-error-types.h"

struct etpan_abook * etpan_abook_new(void);
void etpan_abook_free(struct etpan_abook * abook);

void etpan_abook_set_id(struct etpan_abook * abook, char * id);
char * etpan_abook_get_id(struct etpan_abook * abook);

struct etpan_error * etpan_abook_setup(struct etpan_abook * abook) WARN_UNUSED_RESULT;
void etpan_abook_unsetup(struct etpan_abook * abook);

void * etpan_abook_get_data(struct etpan_abook * abook);
void etpan_abook_set_data(struct etpan_abook * abook, void * data);

void etpan_abook_set_driver(struct etpan_abook * abook,
    struct etpan_abook_driver * driver);
struct etpan_abook_driver *
etpan_abook_get_driver(struct etpan_abook * abook);

struct etpan_abook_entry * etpan_abook_entry_new(void);
void etpan_abook_entry_free(struct etpan_abook_entry * entry);

void etpan_abook_entry_set_firstname(struct etpan_abook_entry * entry,
    char * firstname);
void etpan_abook_entry_set_lastname(struct etpan_abook_entry * entry,
    char * lastname);
void etpan_abook_entry_set_fullname(struct etpan_abook_entry * entry,
    char * fullname);
void etpan_abook_entry_set_address(struct etpan_abook_entry * entry,
    char * address);
void etpan_abook_entry_set_nickname(struct etpan_abook_entry * entry,
    char * nickname);

char * etpan_abook_entry_get_firstname(struct etpan_abook_entry * entry);
char * etpan_abook_entry_get_lastname(struct etpan_abook_entry * entry);
char * etpan_abook_entry_get_fullname(struct etpan_abook_entry * entry);
char * etpan_abook_entry_get_address(struct etpan_abook_entry * entry);
char * etpan_abook_entry_get_nickname(struct etpan_abook_entry * entry);

struct etpan_abook_entry *
etpan_abook_entry_dup(struct etpan_abook_entry * entry);

int etpan_abook_entry_match(struct etpan_abook_entry * entry,
    const char * key);

struct etpan_thread_op *
etpan_abook_lookup(struct etpan_thread_manager_app * manager,
    struct etpan_abook * abook, char * key,
    void (* callback)(int, struct etpan_abook_lookup_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_abook_disconnect(struct etpan_thread_manager_app * manager,
    struct etpan_abook * abook,
    void (* callback)(int, void * /* dummy argument */,
        void *),
    void * cb_data);

void etpan_abook_entry_str(char * str, size_t len,
    struct etpan_abook_entry * entry);

#endif
