/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-ldap-types.h,v 1.4 2004/03/18 01:32:02 hoa Exp $
 */

#ifndef ETPAN_LDAP_TYPES_H

#define ETPAN_LDAP_TYPES_H

#include <inttypes.h>

#define ETPAN_DEFAULT_LDAP_PORT 389
#define ETPAN_DEFAULT_LDAP_VERSION 3
#define ETPAN_DEFAULT_LDAP_FILTER "(|(cn=%*)(mail=%*)(givenname=%*)(sn=%*))"

enum {
  ETPAN_LDAP_NO_ERROR = 0,
  ETPAN_LDAP_ERROR_SYSTEM,
  ETPAN_LDAP_ERROR_AUTH,
  ETPAN_LDAP_ERROR_LDAP,
  ETPAN_LDAP_ERROR_PARTIAL,
  ETPAN_LDAP_ERROR_INTERNAL
};

struct etpan_ldap_config {
  char * hostname;
  uint16_t port;
  int tls;
  int version;
  char * base;
  char * binddn;
  char * bindpw;
  char * filter;
  struct {
    char * mail;
    char * cn;
    char * givenname;
    char * sn;
    char * fullname;
  } attrs;
  int sizelimit;
  int timeout;
};

struct etpan_ldap_abook_entry {
  char * firstname;
  char * fullname;
  char * lastname;
  char * address;
};

struct etpan_ldap_session;

#endif

