#ifndef ETPAN_FILTER_ACTION_H

#define ETPAN_FILTER_ACTION_H

#include "etpan-filter-action-types.h"

struct etpan_filter_action * etpan_filter_action_dup(struct etpan_filter_action * action);

struct etpan_filter_action * etpan_filter_action_new(char * name,
    carray * param_list);
void etpan_filter_action_free(struct etpan_filter_action * action);

void etpan_filter_action_list_run(struct etpan_filter_state * filter_state,
    carray * action_list,
    struct etpan_message * msg,
    void (* callback)(void *), void * cb_data);

void etpan_filter_action_run(struct etpan_filter_state * filter_state,
    struct etpan_filter_action * action,
    struct etpan_message * msg,
    void (* callback)(int stop, void *), void * cb_data);

void etpan_filter_action_register_description(struct etpan_filter_action_description * description);
void etpan_filter_action_unregister_description(char * name);

void etpan_filter_action_register_default(void);
void etpan_filter_action_unregister_all(void);

char * etpan_filter_action_get_description_name(struct etpan_filter_action * action);
carray * etpan_filter_action_get_param_list(struct etpan_filter_action * action);

#endif
