#ifndef ETPAN_FILTER_CONDITION_H

#include "etpan-filter-condition-types.h"

struct etpan_filter_condition * etpan_filter_condition_new(char * name,
    carray * param_list);
void etpan_filter_condition_free(struct etpan_filter_condition * condition);

void etpan_filter_condition_add(struct etpan_filter_condition * parent,
    struct etpan_filter_condition * child);

struct etpan_filter_condition * etpan_filter_condition_dup(struct etpan_filter_condition * condition);

void etpan_filter_condition_evaluate(struct etpan_filter_condition * condition,
    struct etpan_message * msg,
    void (* callback)(int result, void * data),
    void * data);

void etpan_filter_condition_register_description(struct etpan_filter_condition_description * description);
void etpan_filter_condition_unregister_description(char * name);

void etpan_filter_condition_register_default(void);
void etpan_filter_condition_unregister_all(void);

char * etpan_filter_condition_get_description_name(struct etpan_filter_condition * condition);
carray * etpan_filter_condition_get_param_list(struct etpan_filter_condition * condition);
carray * etpan_filter_condition_get_children(struct etpan_filter_condition * condition);

#endif
