#ifndef ETPAN_FILTER_CONFIG_H

#define ETPAN_FILTER_CONFIG_H

#include "etpan-filter-config-types.h"
#include "etpan-filter-types.h"
#include "etpan-error-types.h"
#include "etpan-message.h"

struct etpan_filter_config * etpan_filter_config_new(void);

void etpan_filter_config_free(struct etpan_filter_config * config);

struct etpan_error * etpan_filter_config_read(struct etpan_filter_config * config, char * filename) WARN_UNUSED_RESULT;

struct etpan_error * etpan_filter_config_read_default(void) WARN_UNUSED_RESULT;

struct etpan_filter_config * etpan_filter_config_get_default(void);

void etpan_filter_config_set_default(struct etpan_filter_config * config);

struct etpan_filter_config * etpan_filter_config_dup(struct etpan_filter_config * config);

void etpan_filter_config_apply_message(struct etpan_filter_state * state,
    struct etpan_filter_config * config,
    struct etpan_message * msg,
    void (* filter_callback)(void *), void * cb_data);

carray * etpan_filter_config_get_rule_list(struct etpan_filter_config * config);

void etpan_filter_config_add_rule(struct etpan_filter_config * config,
    struct etpan_filter * rule);

void etpan_filter_config_reset(struct etpan_filter_config * config);

struct etpan_error * etpan_filter_config_write(struct etpan_filter_config * config, char * filename) WARN_UNUSED_RESULT;

struct etpan_error * etpan_filter_config_write_default(void) WARN_UNUSED_RESULT;

#endif
