%option prefix="etpan_filter_lexer_"
%option noyywrap yylineno

identifier [[:alpha:]_][[:alnum:]_/-]*

%{
#include <inttypes.h>

/* etpan-filter-parser-internal.h must be included
   before etpan-filter-parser.h */
#include "etpan-filter-parser-internal.h"
#include "etpan-filter-parser.h"

#define YY_INPUT(buf,res,size) do {			\
   res = conf_file.read(buf, 1, size, conf_file.data);	\
   res = res <= 0? YY_NULL: res;			\
} while (0)

#define YY_USER_ACTION do { \
   int i; \
   for(i = 0 ; i < yyleng ; i ++) { \
     if (yytext[i] == '\n') { \
       etpan_filter_parser_param.column = 0; \
       etpan_filter_parser_param.line ++; \
     } \
     else { \
       etpan_filter_parser_param.column ++; \
     } \
     etpan_filter_parser_param.offset ++; \
   } \
} while (0);

static struct {
    void *data;
    etpan_filter_lexer_io_fn read;
} conf_file;
%}

%x C_COMMENT

%%
    conf_file.data = etpan_filter_parser_param.data;
    conf_file.read = etpan_filter_parser_param.reader;

[ \t]                           /* skip blanks */
[\r\n]

{identifier} { etpan_filter_lexer_lval.s = yytext; return IDENT; }
[+\-]?[[:digit:]]+ { etpan_filter_lexer_lval.i = strtoll(yytext, NULL, 0); return INT; }

\'[^\']*\' { yytext[yyleng-1]=0; etpan_filter_lexer_lval.s = yytext + 1; return STRING; }
\"\" |

\"([^\"]|\\\")*[^\\]\" { yytext[yyleng-1]=0; etpan_filter_lexer_lval.s = yytext + 1; return DSTRING; }

[{}():\n|&,;] { return yytext[0]; }

true { return TRUE_KEYWORD; }
false { return FALSE_KEYWORD; }

"/*" { BEGIN(C_COMMENT); }

<C_COMMENT>([^*]|"*"[^/])* { }

<C_COMMENT>"*/" { BEGIN(INITIAL); }

<C_COMMENT><<EOF>> { YY_FATAL_ERROR("non-terminated comment"); BEGIN(INITIAL); }
