#include "etpan-filter-parser-glue.h"

#include <pthread.h>

#include "etpan-filter-parser-internal.h"
#include "etpan-filter-config.h"

static pthread_mutex_t parser_lock = PTHREAD_MUTEX_INITIALIZER;

struct etpan_filter_parser_param_s etpan_filter_parser_param;

/* returns 0 on success */
static int etpan_filter_parser_with_function(struct etpan_filter_config * config,
    etpan_filter_lexer_io_fn reader, void * data)
{
  int r;
  
  pthread_mutex_lock(&parser_lock);
  etpan_filter_parser_param.data = data;
  etpan_filter_parser_param.reader = reader;
  etpan_filter_parser_param.config = config;
  r = etpan_filter_lexer_parse();
  pthread_mutex_unlock(&parser_lock);
  
  if (r != 0) {
    etpan_filter_config_reset(config);
    return -1;
  }
  
  return 0;
}

int etpan_filter_parser_parse_file(struct etpan_filter_config * config,
    char * filename)
{
    FILE *f;
    int r;
    
    f = fopen(filename, "r");
    if (f == NULL)
	return -1;
    
    r = etpan_filter_parser_with_function(config,
        (etpan_filter_lexer_io_fn) fread, f);
    
    fclose(f);
    
    return r;
}
