#ifndef ETPAN_FILTER_PARSER_INTERNAL_H

#define ETPAN_FILTER_PARSER_INTERNAL_H

#include <libetpan/libetpan.h>

#define yymaxdepth etpan_filter_lexer_maxdepth
#define yyparse    etpan_filter_lexer_parse
#define yyerror    etpan_filter_lexer_error
#define yylval     etpan_filter_lexer_lval
#define yychar     etpan_filter_lexer_char
#define yydebug    etpan_filter_lexer_debug
#define yypact     etpan_filter_lexer_pact
#define yyr1       etpan_filter_lexer_r1
#define yyr2       etpan_filter_lexer_r2
#define yydef      etpan_filter_lexer_def
#define yychk      etpan_filter_lexer_chk
#define yypgo      etpan_filter_lexer_pgo
#define yyact      etpan_filter_lexer_act
#define yyexca     etpan_filter_lexer_exca
#define yyerrflag  etpan_filter_lexer_errflag
#define yynerrs    etpan_filter_lexer_nerrs
#define yyps       etpan_filter_lexer_ps
#define yypv       etpan_filter_lexer_pv
#define yys        etpan_filter_lexer_s
#define yy_yys     etpan_filter_lexer_yys
#define yystate    etpan_filter_lexer_state
#define yytmp      etpan_filter_lexer_tmp
#define yyv        etpan_filter_lexer_v
#define yy_yyv     etpan_filter_lexer_yyv
#define yyval      etpan_filter_lexer_val
#define yylloc     etpan_filter_lexer_lloc
#define yyreds     etpan_filter_lexer_reds
#define yytoks     etpan_filter_lexer_toks
#define yylhs      etpan_filter_lexer_lhs
#define yylen      etpan_filter_lexer_len
#define yydefred   etpan_filter_lexer_defred
#define yydgoto    etpan_filter_lexer_dgoto
#define yysindex   etpan_filter_lexer_sindex
#define yyrindex   etpan_filter_lexer_rindex
#define yygindex   etpan_filter_lexer_gindex
#define yytable    etpan_filter_lexer_table
#define yycheck    etpan_filter_lexer_check
#define yyname     etpan_filter_lexer_name
#define yyrule     etpan_filter_lexer_rule

typedef size_t (*etpan_filter_lexer_io_fn)(void*, size_t, size_t, void *);

struct function_call {
  char * function_name;
  carray * param_list;
};

struct etpan_filter_parser_param_s {
  void * data;
  etpan_filter_lexer_io_fn reader;
  struct etpan_filter_config * config;
  unsigned int offset;
  unsigned int line;
  unsigned int column;
  char * current_function_name;
  carray * current_param_list;
  struct function_call * current_function_call;
  carray * condition_stack;
  carray * action_list;
  char * current_rule_name;
};

extern struct etpan_filter_parser_param_s etpan_filter_parser_param;

extern int etpan_filter_lexer_parse(void);
extern int etpan_filter_lexer_lex(void);
extern void etpan_filter_parser_cleanup(void);

#endif
