%option prefix="etpan_filter_parser_"
%option noyywrap yylineno

keyword [[:alpha:]_][[:alnum:]_/-]*

%{
%}

%%

[ \t]                           /* skip blanks */
#.*\n                           /* comment */
^[ \t]*\n                       /* skip blank lines */

{keyword} { etpan_filter_parser_lval.s = strdup(yytext); return IDENT; }
[+\-]?[[:digit:]]+ { etpan_filter_parser_lval.i = strtoll(yytext, NULL, 0); return INT; }

\'[^\']*\' { yytext[yyleng-1]=0; tcc_lval.s = yytext + 1; return STRING; }
\"\" |
\"([^\"]|\\\")*[^\\]\" { yytext[yyleng-1]=0; tcc_lval.s = yytext + 1; return DST
RING; }
