#ifndef ETPAN_FILTER_TYPES_H

#define ETPAN_FILTER_TYPES_H

#include <libetpan/libetpan.h>

#include "etpan-message-types.h"

struct etpan_filter {
  char * name;
  struct etpan_filter_condition * condition;
  carray * action_list;
};

struct etpan_filter_state {
  struct etpan_filter_config * config;
  unsigned int current_index;
  void (* filter_callback)(void *);
  void * cb_data;
  struct etpan_message * msg;
  
  chash * update_folder_hash; /* folder names to update */
  chash * checkpoint_folder_hash; /* folder names to checkpoint */
};

#endif
