#ifndef ETPAN_FILTER_H

#define ETPAN_FILTER_H

#include "etpan-filter-types.h"
#include "etpan-filter-action-types.h"

void etpan_filter_init(void);
void etpan_filter_done(void);

struct etpan_filter_state * etpan_filter_state_new(void);
void etpan_filter_state_free(struct etpan_filter_state * state);

void etpan_filter_message(struct etpan_filter_state * filter_state,
    struct etpan_filter * filter,
    struct etpan_message * msg,
    void (* callback)(int filtered, void *), void * cb_data);

struct etpan_filter * etpan_filter_new(void);

struct etpan_filter * etpan_filter_dup(struct etpan_filter * filter);

void etpan_filter_free(struct etpan_filter * filter);

void etpan_filter_set_condition(struct etpan_filter * filter,
    struct etpan_filter_condition * condition);

void etpan_filter_add_action(struct etpan_filter * filter,
    struct etpan_filter_action * action);

void etpan_filter_set_name(struct etpan_filter * filter, char * name);

char * etpan_filter_get_name(struct etpan_filter * filter);

struct etpan_filter_condition * etpan_filter_get_condition(struct etpan_filter * filter);

carray * etpan_filter_get_action_list(struct etpan_filter * filter);

#endif
