#ifndef ETPAN_FOLDER_FILTER_H

#define ETPAN_FOLDER_FILTER_H

#include "etpan-folder-filter-types.h"
#include "etpan-thread-manager-app-types.h"

struct etpan_folder_filter * etpan_folder_filter_new(void);

void etpan_folder_filter_ref(struct etpan_folder_filter * folder_filter);

void etpan_folder_filter_unref(struct etpan_folder_filter * folder_filter);

void etpan_folder_filter_set_folder(struct etpan_folder_filter * folder_filter,
    struct etpan_folder * folder);

struct etpan_folder * etpan_folder_filter_get_folder(struct etpan_folder_filter * folder_filter);

void etpan_folder_filter_setup(struct etpan_folder_filter * folder_filter);

void etpan_folder_filter_set_filter(struct etpan_folder_filter * folder_filter,
    struct etpan_filter_config * filter_config);

void etpan_folder_filter_run(struct etpan_folder_filter * folder_filter,
    void (* step_callback)(void *),
    void (* callback)(void *),
    void * cb_data);

void etpan_folder_filter_cancel(struct etpan_folder_filter * folder_filter);

int etpan_folder_filter_is_running(struct etpan_folder_filter * folder_filter);

char * etpan_folder_filter_get_path_for_folder(struct etpan_folder_filter * folder_filter);

void etpan_folder_filter_set_path(struct etpan_folder_filter * folder_filter,
    char * path);

void etpan_folder_filter_fetch_filtered_message_list(struct etpan_thread_manager_app * manager,
    struct etpan_folder_filter * folder_filter,
    void (* callback)(int, struct etpan_folder_filter_filtered_msg_list_result *,
        void *),
    void * data);

void etpan_folder_filter_force_run(struct etpan_folder_filter * folder_filter);

#endif
