#ifndef ETPAN_IMAP_FOLDER_SYNC_PRIVATE_H

#define ETPAN_IMAP_FOLDER_SYNC_PRIVATE_H

#include <libetpan/libetpan.h>
#include "etpan-imap-folder-sync-types.h"

struct etpan_error *
etpan_imap_folder_sync_fetch_msg_list(struct etpan_folder * folder,
    struct etpan_imap_folder_sync * folder_sync,
    chash * current_msg_list);

void etpan_imap_folder_sync_check_msg(struct etpan_imap_folder_sync * folder_sync,
    struct etpan_message * msg,
    struct etpan_message_flags * flags);

struct etpan_error *
etpan_imap_folder_sync_status(struct etpan_imap_folder_sync * folder_sync,
    unsigned int * p_count, unsigned int * p_unseen, unsigned int * p_recent);

struct etpan_error *
etpan_imap_folder_sync_get_body(struct etpan_imap_folder_sync * folder_sync,
    char * uid, struct mailimap_body ** result);

struct etpan_error *
etpan_imap_folder_sync_get_part(struct etpan_imap_folder_sync * folder_sync,
    char * uid, char * section, int part_type,
    void ** p_data, size_t * p_length);

struct etpan_error *
etpan_imap_folder_sync_check(struct etpan_imap_folder_sync * folder_sync);

struct etpan_error *
etpan_imap_folder_sync_append(struct etpan_imap_folder_sync * folder_sync,
    char * content, size_t length, struct etpan_message_flags * flags);

void etpan_imap_folder_sync_disconnect_nt(struct etpan_imap_folder_sync * folder_sync);

#endif
