#ifndef ETPAN_IMAP_FOLDER_SYNC_H

#define ETPAN_IMAP_FOLDER_SYNC_H

#include "etpan-imap-folder-sync-types.h"
#include "etpan-error-types.h"
#include "etpan-thread-manager-app-types.h"

struct etpan_imap_folder_sync *
etpan_imap_folder_sync_new(struct etpan_imap_sync * imap_sync,
    char * location, int noinferiors, char separator);

void etpan_imap_folder_sync_ref(struct etpan_imap_folder_sync * folder_sync);
void etpan_imap_folder_sync_unref(struct etpan_imap_folder_sync * folder_sync);

void etpan_imap_folder_sync(struct etpan_thread_manager_app * manager,
                            struct etpan_imap_folder_sync * folder_sync);

void etpan_imap_folder_set_sync_now(struct etpan_imap_folder_sync * folder_sync);

double etpan_imap_folder_sync_next_op_date(struct etpan_imap_folder_sync * folder_sync);

int etpan_imap_folder_sync_get_priority(struct etpan_imap_folder_sync * folder_sync);

char * etpan_imap_folder_sync_get_location(struct etpan_imap_folder_sync * folder_sync);

int etpan_imap_folder_sync_get_noinferiors(struct etpan_imap_folder_sync * folder_sync);

char etpan_imap_folder_sync_get_imap_separator(struct etpan_imap_folder_sync * folder_sync);

void etpan_imap_folder_sync_open(struct etpan_imap_folder_sync * folder_sync);
void etpan_imap_folder_sync_close(struct etpan_imap_folder_sync * folder_sync);

struct etpan_error * etpan_imap_folder_sync_get_error(struct etpan_imap_folder_sync * folder_sync);

#endif
