#ifndef ETPAN_IMAP_SYNC_TYPES_H

#define ETPAN_IMAP_SYNC_TYPES_H

#include "etpan-sqldb-types.h"
#include <pthread.h>

#define ETPAN_FOLDER_IMAP_SYNC_CONTENT_UPDATED_ENDED_SIGNAL \
 "org.etpan.imap-sync.folder-content-updated"
#define ETPAN_STORAGE_IMAP_SYNC_CONTENT_UPDATED_ENDED_SIGNAL \
 "org.etpan.imap-sync.storage-content-updated"

#define ETPAN_IMAP_SYNC_STORAGE_CONTENT_UPDATED_SIGNAL \
 "org.etpan.imap-sync.storage-content-updated"

#define ETPAN_IMAP_SYNC_OP_ENDED_SIGNAL \
 "org.etpan.imap-sync.op-ended"

enum {
  ETPAN_IMAP_SYNC_PRIORITY_HAS_BODY,
  ETPAN_IMAP_SYNC_PRIORITY_HAS_ENV,
  ETPAN_IMAP_SYNC_PRIORITY_HAS_NOTHING,
  ETPAN_IMAP_SYNC_PRIORITY_DISCONNECT,
  ETPAN_IMAP_SYNC_PRIORITY_USER_OP,
};

#define ETPAN_IMAP_SYNC_PRIORITY_OPENED 100
#define ETPAN_IMAP_SYNC_PRIORITY_INBOX 1000
#define ETPAN_IMAP_SYNC_PRIORITY_HAS_APPEND_ITEMS 2000

struct etpan_imap_sync {
  char * id;
  struct etpan_account * account;
  
  char * hostname;
  int port;
  int connection_type;
  int auth_type;
  char * username;
  char * password;
  char * command;
  char * base_location;
  char main_imap_separator;
  
  /* threaded */
  int connected;
  int connected_count;
  char * threaded_hostname;
  int threaded_port;
  int threaded_connection_type;
  int threaded_auth_type;
  char * threaded_username;
  char * threaded_password;
  char * threaded_command;
  char * threaded_base_location;
  char threaded_main_imap_separator;
  int should_disconnect;
  char * threaded_current_location;
  
  struct mailstorage * ep_storage;
  struct etpan_sqldb * folderlist_db;
  pthread_mutex_t folderlist_db_lock;
  
  chash * folder_hash;
  pthread_mutex_t folder_hash_lock;
  carray * pending_folders;
  pthread_mutex_t pending_folders_lock;
  int disconnecting_folders;
  
  struct etpan_thread_op * op;
  
  int state;
  double last_sync_date;
  int syncing;
  
  int last_sync_success;
  struct etpan_error * error;
  
  struct etpan_storage * dummy_storage;
};

#endif
