#ifndef ETPAN_IMAP_SYNC_H

#define ETPAN_IMAP_SYNC_H

#include "etpan-imap-sync-types.h"
#include "etpan-thread-manager-app-types.h"
#include "etpan-error-types.h"

struct etpan_imap_sync * etpan_imap_sync_new(void);
void etpan_imap_sync_free(struct etpan_imap_sync * imap_sync);

/* properties */

void etpan_imap_sync_set_id(struct etpan_imap_sync * imap_sync,
    char * id);

char * etpan_imap_sync_get_id(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_hostname(struct etpan_imap_sync * imap_sync,
    char * hostname);

char * etpan_imap_sync_get_hostname(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_port(struct etpan_imap_sync * imap_sync, int port);
int etpan_imap_sync_get_port(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_connection_type(struct etpan_imap_sync * imap_sync,
    int connection_type);
int etpan_imap_sync_get_connection_type(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_auth_type(struct etpan_imap_sync * imap_sync,
    int auth_type);
int etpan_imap_sync_get_auth_type(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_username(struct etpan_imap_sync * imap_sync,
    char * username);
char * etpan_imap_sync_get_username(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_password(struct etpan_imap_sync * imap_sync,
    char * password);
char * etpan_imap_sync_get_password(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_base_location(struct etpan_imap_sync * imap_sync,
    char * base_location);
char * etpan_imap_sync_get_base_location(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync_set_command(struct etpan_imap_sync * imap_sync,
    char * command);
char * etpan_imap_sync_get_command(struct etpan_imap_sync * imap_sync);

/* setup */

void etpan_imap_sync_setup(struct etpan_imap_sync * imap_sync);
void etpan_imap_sync_unsetup(struct etpan_imap_sync * imap_sync);

/* account */
void etpan_imap_sync_set_account(struct etpan_imap_sync * imap_sync,
    struct etpan_account * account);
struct etpan_account *
etpan_imap_sync_get_account(struct etpan_imap_sync * imap_sync);

void etpan_imap_sync(struct etpan_thread_manager_app * manager,
    struct etpan_imap_sync * imap_sync);

double etpan_imap_sync_next_op_date(struct etpan_imap_sync * imap_sync);

char etpan_imap_sync_get_main_imap_separator(struct etpan_imap_sync * imap_sync);

int etpan_imap_sync_get_status(struct etpan_imap_sync * imap_sync, char * location, unsigned int * p_count, unsigned int * p_unseen, unsigned int * p_recent);
struct etpan_error *
etpan_imap_sync_set_status(struct etpan_imap_sync * imap_sync, char * location, unsigned int count, unsigned int unseen, unsigned int recent) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_sync_set_lastuid(struct etpan_imap_sync * imap_sync, char * location, uint32_t lastuid) WARN_UNUSED_RESULT;
uint32_t etpan_imap_sync_get_lastuid(struct etpan_imap_sync * imap_sync, char *location);

struct etpan_error *
etpan_imap_sync_set_envlastuid(struct etpan_imap_sync * imap_sync, char * location, uint32_t envlastuid) WARN_UNUSED_RESULT;
uint32_t etpan_imap_sync_get_envlastuid(struct etpan_imap_sync * imap_sync, char *location);

struct etpan_error *
etpan_imap_sync_set_bodylastuid(struct etpan_imap_sync * imap_sync, char * location, uint32_t lastuid) WARN_UNUSED_RESULT;
uint32_t etpan_imap_sync_get_bodylastuid(struct etpan_imap_sync * imap_sync, char *location);

struct etpan_error *
etpan_imap_sync_set_uidvalidity(struct etpan_imap_sync * imap_sync,
    char * location, uint32_t value);

uint32_t etpan_imap_sync_get_uidvalidity(struct etpan_imap_sync * imap_sync,
    char * location);

struct etpan_error * etpan_imap_sync_get_error(struct etpan_imap_sync * imap_sync);

struct etpan_error *
etpan_imap_sync_force_fetch_folder_list(struct etpan_imap_sync * imap_sync);

int etpan_imap_sync_is_disconnected(struct etpan_imap_sync * imap_sync);
void etpan_imap_sync_disconnect(struct etpan_imap_sync * imap_sync);

#endif
