#ifndef ETPAN_POP_SYNC_TYPES_H

#define ETPAN_POP_SYNC_TYPES_H

#include "etpan-account-types.h"

#define ETPAN_POP_SYNC_OP_ENDED_SIGNAL \
 "org.etpan.pop-sync.op-ended"

struct etpan_pop_sync {
  char * id;
  struct etpan_account * account;
  
  char * hostname;
  int port;
  int connection_type;
  int auth_type;
  char * username;
  char * password;
  char * command;
  int days;
  
  /* threaded */
  struct mailstorage * ep_storage;
  char * threaded_hostname;
  int threaded_port;
  int threaded_connection_type;
  int threaded_auth_type;
  char * threaded_username;
  char * threaded_password;
  char * threaded_command;
  int threaded_days;
  
  int cancelled;
  int state;
  unsigned int current_msg;
  carray * msg_list;
  char * fetch_result_content;
  size_t fetch_result_content_size;
  struct etpan_error * error;
  void (* callback)(void *);
  void * cb_data;
  int syncing;
  int connected;
  
  double last_sync_date;
  struct etpan_sqldb * uid_db;
  
  struct etpan_storage * dummy_storage;
};

#endif
