#ifndef ETPAN_POP_SYNC_H

#define ETPAN_POP_SYNC_H

#include "etpan-pop-sync-types.h"

struct etpan_pop_sync * etpan_pop_sync_new(void);
void etpan_pop_sync_free(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_account(struct etpan_pop_sync * pop_sync,
    struct etpan_account * account);

struct etpan_account *
etpan_pop_sync_get_account(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_id(struct etpan_pop_sync * pop_sync,
    char * id);
char * etpan_pop_sync_get_id(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_hostname(struct etpan_pop_sync * pop_sync,
    char * hostname);
char * etpan_pop_sync_get_hostname(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_port(struct etpan_pop_sync * pop_sync, int port);
int etpan_pop_sync_get_port(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_connection_type(struct etpan_pop_sync * pop_sync,
    int connection_type);
int etpan_pop_sync_get_connection_type(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_auth_type(struct etpan_pop_sync * pop_sync,
    int auth_type);
int etpan_pop_sync_get_auth_type(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_username(struct etpan_pop_sync * pop_sync,
    char * username);
char * etpan_pop_sync_get_username(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_password(struct etpan_pop_sync * pop_sync,
    char * password);
char * etpan_pop_sync_get_password(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_set_command(struct etpan_pop_sync * pop_sync,
    char * command);
char * etpan_pop_sync_get_command(struct etpan_pop_sync * pop_sync);

/* -1 disable the feature */
void etpan_pop_sync_set_days(struct etpan_pop_sync * pop_sync,
    unsigned int days);
int etpan_pop_sync_get_days(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_setup(struct etpan_pop_sync * pop_sync);
void etpan_pop_sync_unsetup(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_start(struct etpan_pop_sync * pop_sync,
    void (* callback)(void *), void * user_data);
void etpan_pop_sync_cancel(struct etpan_pop_sync * pop_sync);

void etpan_pop_sync_disconnect_nt(struct etpan_pop_sync * pop_sync);

struct etpan_error * etpan_pop_sync_get_error(struct etpan_pop_sync * pop_sync);

double etpan_pop_sync_next_op_date(struct etpan_pop_sync * pop_sync);

int etpan_pop_sync_is_syncing(struct etpan_pop_sync * pop_sync);

#endif
