/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-imap.h,v 1.6 2004/09/14 23:26:15 hoa Exp $
 */

#ifndef ETPAN_IMAP_H

#define ETPAN_IMAP_H

#include <libetpan/libetpan.h>
#include "etpan-imap-types.h"
#include "etpan-error-types.h"

struct etpan_error *
etpan_imap_lsub_mailboxes(mailsession * session,
    char * wildcard, carray ** result) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_list_mailboxes(mailsession * session,
    char * wildcard, carray ** result) WARN_UNUSED_RESULT;

void etpan_imap_list_mailboxes_free(carray * info_array);

struct etpan_error *
etpan_imap_select(mailsession * session,
    char * mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_create(mailsession * session,
    char * mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_delete(mailsession * session,
    char * mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_rename(mailsession * session,
    char * mailbox, char * new_mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_subscribe(mailsession * session,
    char * mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_unsubscribe(mailsession * session,
    char * mailbox) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_imap_store_flags(mailsession * session, char * mailbox,
    uint32_t first, uint32_t last,
    struct mail_flags * flags);

struct mail_flags *
etpan_imap_flags_to_lep(struct mailimap_msg_att_dynamic * att_dyn);

struct mailimap_flag_list *
etpan_imap_flags_from_lep(struct mail_flags * flags);

struct etpan_error *
etpan_imap_append(mailsession * session, char * mailbox,
    char * content, size_t content_length, struct mail_flags * flags);

struct etpan_error *
etpan_imap_expunge(mailsession * session, char * mailbox);

struct etpan_error * etpan_imap_status(mailsession * session,
    const char * mailbox,
    unsigned int * result_messages,
    unsigned int * result_unseen,
    unsigned int * result_recent);

void etpan_imap_get_fields_content_from_body(struct mailimap_body * imap_body,
    struct mailmime_fields ** p_mime_fields,
    struct mailmime_content ** p_mime_content,
    uint32_t * p_mime_size);

struct mailmime * etpan_imap_body_to_lep(struct mailimap_body * imap_body);

struct mailimf_fields *
etpan_imap_env_to_lep(struct mailimap_envelope * env,
    char * ref_str, size_t ref_size);

#endif
