#ifndef ETPAN_MBOX_CACHE_H

#define ETPAN_MBOX_CACHE_H

#include "etpan-mbox-cache-types.h"

void etpan_mbox_cache_set_default(struct etpan_mbox_cache * cache);
struct etpan_mbox_cache * etpan_mbox_cache_get_default(void);

struct etpan_mbox_cache * etpan_mbox_cache_new(char * cache_path);
void etpan_mbox_cache_free(struct etpan_mbox_cache * cache);

void etpan_mbox_cache_setup(struct etpan_mbox_cache * cache);
void etpan_mbox_cache_unsetup(struct etpan_mbox_cache * cache);

void etpan_mbox_cache_set_count(struct etpan_mbox_cache * cache,
    char * path, unsigned int count,
    unsigned int unseen, unsigned int recent);

int etpan_mbox_cache_get_count(struct etpan_mbox_cache * cache,
    char * path, unsigned int * p_count,
    unsigned int * p_unseen, unsigned int * p_recent);

void etpan_mbox_cache_invalidate(struct etpan_mbox_cache * cache,
    char * path);

#endif
