#ifndef ETPAN_STORAGE_NEWS_H

#define ETPAN_STORAGE_NEWS_H

#include "etpan-storage-types.h"
#include "etpan-storage-news-types.h"
#include "etpan-thread-manager-app.h"

struct etpan_storage * etpan_storage_news_new(void);

void etpan_storage_news_set_hostname(struct etpan_storage * storage,
    char * hostname);

char * etpan_storage_news_get_hostname(struct etpan_storage * storage);

void etpan_storage_news_set_port(struct etpan_storage * storage, int port);
int etpan_storage_news_get_port(struct etpan_storage * storage);

void etpan_storage_news_set_connection_type(struct etpan_storage * storage,
    int connection_type);
int etpan_storage_news_get_connection_type(struct etpan_storage * storage);

void etpan_storage_news_set_username(struct etpan_storage * storage,
    char * username);
char * etpan_storage_news_get_username(struct etpan_storage * storage);

void etpan_storage_news_set_password(struct etpan_storage * storage,
    char * password);
char * etpan_storage_news_get_password(struct etpan_storage * storage);

struct etpan_thread_op *
etpan_storage_news_append(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    char * message, size_t length,
    void (* callback)(int, struct etpan_storage_news_append_msg_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_storage_news_append_file(struct etpan_thread_manager_app * manager,
    struct etpan_storage * storage,
    char * filename,
    void (* callback)(int, struct etpan_storage_news_append_msg_result *, void *),
    void * cb_data);

#endif
