/** -*- c -*-
    Copyright (C) 2001-2005  Michael Ahlberg, Mns Rullgrd

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
**/

%option prefix="tcc_"
%option noyywrap yylineno

keyword [[:alpha:]_][[:alnum:]_/-]*
keyref  (\.\.\/)*{keyword}

%{
#include <string.h>
#include <tclist.h>
#include <tcalloc.h>
#include <tcconf.h>
#include "tcc-internal.h"
#include "conf-parse.h"

  /* #define YY_DECL int tcc_lex(void) */

#define YY_INPUT(buf,res,size) {			\
   res = conf_file.read(buf, 1, size, conf_file.data);	\
   res = res <= 0? YY_NULL: res;			\
}

static struct {
    void *data;
    tcio_fn read;
} conf_file;
%}

%%
    conf_file.data = tcc_parse_param.data;
    conf_file.read = tcc_parse_param.rfn;

[ \t]				/* skip blanks */
#.*\n				/* comment */
^[ \t]*\n			/* skip blank lines */

{keyword} { tcc_lval.s = strdup(yytext); return IDENT; }
{keyref} { tcc_lval.s = strdup(yytext); return IDENTD; }
[+\-]?0x[[:xdigit:]]+ |
[+\-]?[[:digit:]]+ { tcc_lval.i = strtoll(yytext, NULL, 0); return INT; }
[+\-]?[[:digit:]]*(\.[[:digit:]]+)([eE][+\-]?[[:digit:]]+)? { tcc_lval.f = strtod(yytext, NULL); return FLOAT; }
\'[^\']*\' { yytext[yyleng-1]=0; tcc_lval.s = yytext + 1; return STRING; }
\"\" |
\"([^\"]|\\\")*[^\\]\" { yytext[yyleng-1]=0; tcc_lval.s = yytext + 1; return DSTRING; }

[{}\[\]:;\n] return (u_char) yytext[0];
