/**
    Copyright (C) 2005  Michael Ahlberg, Mns Rullgrd

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
**/

%{
#include <string.h>
#include "tcc-internal.h"

#define yylex tcc_lex

/*
static void tcc_error(void *, tcio_fn, conf_section *, tclist_t *, char *);
*/
static void tcc_error(char *);

#define PREP_SEC() do {			\
    merge = tclist_new(TC_LOCK_SLOPPY);		\
} while(0)

#define PUSH_SEC(n, t) do {				\
    tcc_entry *te = create_entry(tcc_parse_param.cur_section, n, t);	\
    tclist_push(tcc_parse_param.section_stack, tcc_parse_param.cur_section);		\
    tcc_parse_param.cur_section = te->section;				\
    tclist_destroy(tcc_parse_param.cur_section->merge, NULL);		\
    tcc_parse_param.cur_section->merge = merge;				\
    merge = NULL;					\
    free(n);						\
} while(0)

#define POP_SEC() do {				\
    tcc_parse_param.cur_section = tclist_pop(tcc_parse_param.section_stack);	\
} while(0)

#define MERGE(n) tclist_push(merge, n)

#define NEW_ENTRY(n) do {					\
    cur_entry = create_entry(tcc_parse_param.cur_section, n, TCC_VALUE);	\
    free(n);							\
} while(0)

static tclist_t *merge;
static tcc_entry *cur_entry;
struct tcc_parse_param_s tcc_parse_param;
%}

/*
%parse-param {void *data}
%parse-param {tcio_fn rfn}
%parse-param {conf_section *cur_section}
%parse-param {tclist_t *section_stack}
*/

/*
%lex-param {void *data}
%lex-param {tcio_fn rfn}
*/

/*
%error-verbose
*/

%union {
    int64_t i;
    double f;
    char *s;
}

%token <i> INT
%token <f> FLOAT
%token <s> STRING
%token <s> DSTRING
%token <s> IDENT
%token <s> IDENTD
%type <s> path

%%

configuration: /* empty */
	| configuration section_or_entry nl
	;
section_or_entry: section
	| msection
	| entry
	;
section: IDENT prep_sec merge '{' { PUSH_SEC($1, TCC_SECTION); } nl
	    configuration '}' nl { POP_SEC(); }
	;
msection: IDENT prep_sec merge '[' { PUSH_SEC($1, TCC_MSECTION); } nl
	    configuration ']' nl { POP_SEC(); }
	;
prep_sec: { PREP_SEC(); }
	;
merge: /* empty */
	| ':' mpaths
	;
mpaths: mpath
	| mpaths mpath
	;
mpath: path { MERGE($1); }
	;
path: IDENT | IDENTD
	;
entry: IDENT { NEW_ENTRY($1); } values end
	;
values: /* empty */
	| values value
	;
value: INT		{ tcc_addint(cur_entry, $1); }
	| FLOAT		{ tcc_addfloat(cur_entry, $1); }
	| STRING	{ tcc_addstring(cur_entry, strdup($1), 0); }
	| DSTRING	{ tcc_addstring(cur_entry, strdup($1), 1); }
	| path		{ tcc_addref(cur_entry, $1); }
	;
nl: | '\n'
	;
end: nl | ';'
	;

%%

/*
static void
tcc_error(void *d, tcio_fn io, conf_section *cs, tclist_t *ss, char *msg)
*/
static void
tcc_error(char *msg)
{
    fprintf(stderr, "%s\n", msg);
}
