#include "etpan-tc.h"

#include <stdlib.h>
#include <string.h>
#include "etpan-error.h"
#include "etpan-log.h"

char * etpan_quote_string(char * value)
{
  char * result;
  size_t len;
  unsigned int i;
  unsigned int p;
  
  len = strlen(value);
  result = malloc(len * 2 + 1);
  if (result == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  p = 0;
  for(i = 0 ; i < len ; i ++) {
    switch (value[i]) {
    case '\"':
    case '\\':
      result[p] = '\\';
      result[p + 1] = value[i];
      p += 2;
      break;
    default:
      result[p] = value[i];
      p ++;
      break;
    }
  }
  
  result[p] = '\0';
  
  return result;
}

