/**
    Copyright (C) 2001-2004  Michael Ahlberg, Måns Rullgård

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
**/

#ifndef _TCENDIAN_H
#define _TCENDIAN_H

#define TCENDIAN_LITTLE 1
#define TCENDIAN_BIG 2


#define bswap_16(x) (((x & 0xff00) >> 8) | ((x & 0x00ff) << 8))

#define bswap_32(x) (((x & 0xff000000) >> 24) |     \
		     ((x & 0x00ff0000) >> 8)  |     \
		     ((x & 0x0000ff00) << 8) |      \
		     ((x & 0x000000ff) << 24))

#define bswap_64(x) (((x & 0xff00000000000000) >> 56) |   \
		     ((x & 0x00ff000000000000) >> 40) |   \
		     ((x & 0x0000ff0000000000) >> 24) |   \
		     ((x & 0x000000ff00000000) >> 8)  |   \
		     ((x & 0x00000000ff000000) << 8)  |   \
		     ((x & 0x0000000000ff0000) << 24) |   \
		     ((x & 0x000000000000ff00) << 40) |   \
		     ((x & 0x00000000000000ff) << 56))

#define TCENDIAN TCENDIAN_BIG

#define htol_16(x) (bswap_16(x))
#define htol_32(x) (bswap_32(x))
#define htol_64(x) (bswap_64(x))

#define htob_16(x) (x)
#define htob_32(x) (x)
#define htob_64(x) (x)

#endif
