#ifndef ETPAN_CONTEXTUAL_MENU_H

#define ETPAN_CONTEXTUAL_MENU_H

#include "etpan-contextual-menu-types.h"

struct etpan_contextual_menu * etpan_contextual_menu_new(void);
void etpan_contextual_menu_free(struct etpan_contextual_menu * menu);

GtkWidget * etpan_contextual_menu_get_main_widget(struct etpan_contextual_menu * menu);

void etpan_contextual_menu_add_item(struct etpan_contextual_menu * menu,
    char * label, GtkWidget * image);
void etpan_contextual_menu_add_check_item(struct etpan_contextual_menu * menu,
    char * label, GtkWidget * image);
void etpan_contextual_menu_add_separator(struct etpan_contextual_menu * menu);

void etpan_contextual_menu_add_sub(struct etpan_contextual_menu * menu,
    char * label, GtkWidget * image,
    struct etpan_contextual_menu * submenu);

void etpan_contextual_menu_set_check_item(struct etpan_contextual_menu * menu,
    int index, int value);

int etpan_contextual_menu_get_check_item(struct etpan_contextual_menu * menu,
    int index);

void etpan_contextual_menu_set_label(struct etpan_contextual_menu * menu,
    int index, char * text);

void etpan_contextual_menu_clear(struct etpan_contextual_menu * menu);

void etpan_contextual_menu_set_enabled(struct etpan_contextual_menu * menu,
    int index, int enabled);

#endif
