#ifndef ETPAN_FOLDER_LIST_TYPES_H

#define ETPAN_FOLDER_LIST_TYPES_H

#include <gtk/gtk.h>
#include <libetpan/libetpan.h>

#include "etpan-gtk-tree-model-types.h"
#include "etpan-contextual-menu-types.h"

#define ETPAN_FOLDER_LIST_SELECTIONCHANGED_SIGNAL \
  "org.etpan.folder-list.selection-changed"

#define ETPAN_FOLDER_LIST_DRAG_FOLDER_NAME \
  "org.etpan.folder-list.drag-folder"

#define ETPAN_FOLDER_LIST_DRAG_MOVE_MSGLIST_SIGNAL \
  "org.etpan.folder-list.drag-move-msglist"
#define ETPAN_FOLDER_LIST_DRAG_COPY_MSGLIST_SIGNAL \
  "org.etpan.folder-list.drag-copy-msglist"

struct etpan_folder_list {
  void * treeinfo;
  GtkWidget * scrolledwindow;
  GtkWidget * treeview;
  etpan_gtk_tree_model * folder_model;
  struct etpan_gtk_tree_data_source folder_datasource;
  
  char * current_selection;
  gulong folder_selected_signal_id;
  gulong motion_signal_id;
  gulong keypress_signal_id;
  chash * path_hash;

#if 0
  gulong update_timer_id;
#endif
  
#if 0
  int check_timer_set;
  gulong check_timer_id;
  chash * folder_to_check;
#endif
  
#if 0
  int status_timer_set;
  gulong status_timer_id;
  chash * folder_to_status;
  chash * storage_status;
#endif

  int progress_animation;
  chash * folder_progress;
  gulong progress_timer_id;
  
  GdkPixbuf ** progress_anim;
  
  int drag_entered;
  gulong drag_motion_signal_id;
  gulong drag_leave_signal_id;
  gulong drag_drop_signal_id;
  gulong drag_scroll_timeout_id;
  gulong drag_auto_expand_timeout_id;
  gint drag_auto_expand_x;
  gint drag_auto_expand_y;
  int drag_drop_type;
  
  gulong drag_begin_signal_id;
  gulong drag_end_signal_id;
  int drag_may_start;
  int drag_expanded;
  gdouble drag_may_start_x;
  gdouble drag_may_start_y;
  GdkDragContext * drag_context;
  int drag_started;
  gulong drag_button_press_signal_id;
  gulong drag_button_release_signal_id;
  gulong drag_mouse_motion_signal_id;
  int drag_has_dest_folder;
  
  struct etpan_contextual_menu * popup_menu;
  
  /* copy */
  char * copy_dest_path;
  int copy_dest_type;
  
  /* create */
  struct etpan_folder * create_parent_folder;
  struct etpan_storage * create_parent_storage;
  
  /* rename */
  struct etpan_folder * rename_parent_folder;
  struct etpan_folder * rename_folder;
  
  /* folder order */
#if 0
  chash * folder_order_hash;
#endif
  
  int unsetup;
  
  chash * copy_msg_hash;
  chash * copy_folder_hash;
  chash * copy_folder_storage_hash;
};

enum {
  ETPAN_FOLDER_LIST_SELECTION_TYPE_INVALID,
  ETPAN_FOLDER_LIST_SELECTION_TYPE_ACCOUNT,
  ETPAN_FOLDER_LIST_SELECTION_TYPE_FOLDER,
  ETPAN_FOLDER_LIST_SELECTION_TYPE_GROUP,
};

enum {
  ETPAN_FOLDER_LIST_DROP_INVALID,
  ETPAN_FOLDER_LIST_DROP_BEFORE,
  ETPAN_FOLDER_LIST_DROP_AFTER,
  ETPAN_FOLDER_LIST_DROP_INTO,
};

#endif
