#ifndef ETPAN_FOLDER_LIST_H

#define ETPAN_FOLDER_LIST_H

#include "etpan-folder-list-types.h"
#include "etpan-folder-types.h"
#include "etpan-storage-types.h"

struct etpan_folder_list * etpan_folder_list_new(void);
void etpan_folder_list_free(struct etpan_folder_list * folder_list);

void etpan_folder_list_setup(struct etpan_folder_list * folder_list);
void etpan_folder_list_unsetup(struct etpan_folder_list * folder_list);

GtkWidget * etpan_folder_list_get_main_widget(struct etpan_folder_list *
    folder_list);

void etpan_folder_list_update_list(struct etpan_folder_list * folder_list);

int
etpan_folder_list_get_selection_type(struct etpan_folder_list * folder_list,
    char * selection_path);

struct etpan_folder *
etpan_folder_list_get_folder(struct etpan_folder_list * folder_list,
    char * path);

struct etpan_account *
etpan_folder_list_get_account(struct etpan_folder_list * folder_list,
    char * path);

void etpan_folder_list_select(struct etpan_folder_list * folder_list,
    char * selection);

#if 0
void etpan_folder_list_set_progress(struct etpan_folder_list * folder_list,
    struct etpan_progress * progress);
#endif

char * etpan_folder_list_get_selection(struct etpan_folder_list * folder_list);

void etpan_folder_list_check(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder);

void etpan_folder_list_start_animation_folder(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder);

void etpan_folder_list_stop_animation_folder(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder);

void etpan_folder_list_copy_folder(struct etpan_folder_list * folder_list,
    struct etpan_folder * source_folder,
    struct etpan_storage * dest_storage,
    struct etpan_folder * dest_folder,
    int delete);

void etpan_folder_list_new_folder(struct etpan_folder_list * folder_list,
    struct etpan_storage * storage,
    struct etpan_folder * folder);

void etpan_folder_list_delete_mailbox(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder);

void etpan_folder_list_rename_mailbox(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder, struct etpan_folder * parent_folder);

void etpan_folder_copy_messages_with_delete(struct etpan_folder_list * folder_list,
    struct etpan_folder * folder, chash * msg_hash, int delete);

#endif
