#ifndef ETPAN_ICON_MANAGER_H

#define ETPAN_ICON_MANAGER_H

#include "etpan-icon-manager-types.h"
#include <gtk/gtk.h>

struct etpan_icon_manager * etpan_icon_manager_new(void);
void etpan_icon_manager_free(struct etpan_icon_manager * manager);

void etpan_icon_manager_set_default(struct etpan_icon_manager * manager);
struct etpan_icon_manager * etpan_icon_manager_get_default(void);

void etpan_icon_manager_set_path(struct etpan_icon_manager * manager,
    char * path);

GtkWidget * etpan_icon_manager_new_image(struct etpan_icon_manager * manager,
    char * name);

GtkWidget * etpan_icon_manager_new_scaled_image(struct etpan_icon_manager * manager,
    char * name, int size);

GdkPixbuf * etpan_icon_manager_get_pixbuf(struct etpan_icon_manager * manager,
    char * name);

GdkPixbuf * etpan_icon_manager_get_scaled_pixbuf(struct etpan_icon_manager * manager,
    char * name, int size);

#endif
