#include "etpan-input-dialog.h"

#include "etpan-backend.h"

static void done_clicked(GtkButton * button, gpointer user_data);
static void cancel_clicked(GtkButton * button, gpointer user_data);

struct etpan_input_dialog * etpan_input_dialog_new(void)
{
  struct etpan_input_dialog * dialog;
  GtkWidget * window;
  GtkWidget * vbox;
  GtkWidget * label;
  GtkWidget * entry;
  GtkWidget * button_box;
  GtkWidget * done_button;
  GtkWidget * cancel_button;
  
  dialog = malloc(sizeof(* dialog));
  if (dialog == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  
  vbox = gtk_vbox_new(FALSE, 0);
  
  label = gtk_label_new("");
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  
  entry = gtk_entry_new();
  gtk_widget_show(entry);
  gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, TRUE, 0);
  
  button_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_END);
  
  cancel_button = gtk_button_new_with_label(_("Cancel"));
  gtk_widget_show(cancel_button);
  gtk_box_pack_start(GTK_BOX(button_box), cancel_button, FALSE, FALSE, 0);
  done_button = gtk_button_new_with_label(_("Done"));
  gtk_widget_show(done_button);
  gtk_box_pack_start(GTK_BOX(button_box), done_button, FALSE, FALSE, 0);
  gtk_widget_show(button_box);
  
  gtk_box_pack_start(GTK_BOX(vbox), button_box, TRUE, TRUE, 0);
  
  gtk_widget_show(vbox);
  
  gtk_container_add(GTK_CONTAINER(window), vbox);
  
  dialog->window = window;
  dialog->label = label;
  dialog->entry = entry;
  dialog->done_button = done_button;
  dialog->cancel_button = cancel_button;
  dialog->result = ETPAN_INPUT_DIALOG_NONE;
  
  return dialog;
}

void etpan_input_dialog_free(struct etpan_input_dialog * dialog)
{
  gtk_widget_destroy(dialog->window);
  free(dialog);
}

void etpan_input_dialog_setup(struct etpan_input_dialog * dialog)
{
  dialog->done_signal_id = g_signal_connect(dialog->done_button,
      "clicked", G_CALLBACK(done_clicked),
      (gpointer) dialog);
  dialog->cancel_signal_id = g_signal_connect(dialog->cancel_button,
      "clicked", G_CALLBACK(cancel_clicked),
      (gpointer) dialog);
}

void etpan_input_dialog_unsetup(struct etpan_input_dialog * dialog)
{
  g_signal_handler_disconnect(dialog->cancel_button,
      dialog->cancel_signal_id);
  g_signal_handler_disconnect(dialog->done_button,
      dialog->done_signal_id);
}

void etpan_input_dialog_show(struct etpan_input_dialog * dialog)
{
  GTK_WIDGET_SET_FLAGS(dialog->done_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(dialog->done_button);
  gtk_window_set_modal(GTK_WINDOW(dialog->window), TRUE);
  gtk_widget_show(dialog->window);
}

void etpan_input_dialog_hide(struct etpan_input_dialog * dialog)
{
  gtk_widget_hide(dialog->window);
}

void etpan_input_dialog_set_title(struct etpan_input_dialog * dialog,
    char * title)
{
  gtk_window_set_title(GTK_WINDOW(dialog->window), title);
}

void etpan_input_dialog_set_text(struct etpan_input_dialog * dialog,
    char * text)
{
  gtk_entry_set_text(GTK_ENTRY(dialog->entry), text);
}

void etpan_input_dialog_set_label(struct etpan_input_dialog * dialog,
    char * label)
{
  gtk_label_set_text(GTK_LABEL(dialog->label), label);
}

int etpan_input_dialog_get_result(struct etpan_input_dialog * dialog)
{
  return dialog->result;
}

char * etpan_input_dialog_get_text(struct etpan_input_dialog * dialog)
{
  return (char *) gtk_entry_get_text(GTK_ENTRY(dialog->entry));
}

static void done_clicked(GtkButton * button, gpointer user_data)
{
  struct etpan_input_dialog * dialog;
  (void) button;
  
  dialog = user_data;
  
  dialog->result = ETPAN_INPUT_DIALOG_DONE;
  
  etpan_signal_send(etpan_signal_manager_get_default(),
    ETPAN_INPUT_DIALOG_CLOSED_SIGNAL, dialog, NULL);
}

static void cancel_clicked(GtkButton * button, gpointer user_data)
{
  struct etpan_input_dialog * dialog;
  (void) button;
  
  dialog = user_data;
  
  dialog->result = ETPAN_INPUT_DIALOG_CANCEL;
  
  etpan_signal_send(etpan_signal_manager_get_default(),
    ETPAN_INPUT_DIALOG_CLOSED_SIGNAL, dialog, NULL);
}
