#ifndef ETPAN_MAIN_WINDOW_TYPES_H

#define ETPAN_MAIN_WINDOW_TYPES_H

#include <gtk/gtk.h>

#include "etpan-toolbar-types.h"
#include "etpan-bookmark-types.h"
#include "etpan-folder-list-types.h"
#include "etpan-message-list-types.h"
#include "etpan-message-view-types.h"
#include "etpan-status-bar-types.h"
#include "etpan-search-field-types.h"
#include "etpan-contextual-menu-types.h"

struct etpan_main_window {
  struct etpan_toolbar * toolbar;
  struct etpan_bookmark_view * bookmark_view;
  struct etpan_folder_list * folder_list;
  struct etpan_tabbed_message_list * tabbed_message_list;
  struct etpan_status_bar * status_bar;
  struct etpan_search_field * search_field;
  struct etpan_contextual_menu * menu;
  struct etpan_contextual_menu * message_menu;
  struct etpan_contextual_menu * folder_menu;
  
  GtkWidget * window;
  GtkWidget * vbox;
  GtkWidget * hpaned;
  GtkWidget * vbox_msg;
  
  int searching;
  
  int saved_split_size;
  gulong hpaned_press_signal_id;
  gulong key_press_signal_id;
};

#endif
