#ifndef ETPAN_MESSAGE_COMPOSER_WINDOW_TYPES_H

#define ETPAN_MESSAGE_COMPOSER_WINDOW_TYPES_H

#include <gtk/gtk.h>
#include <libetpan/libetpan.h>
#include "etpan-backend.h"
#include "etpan-gtk-tree-model-types.h"
#include "etpan-status-bar-types.h"

#define ETPAN_MESSAGE_COMPOSER_WINDOW_FINISHED_SIGNAL \
  "org.etpan.message-composer-window.finished"

struct etpan_message_composer_window {
  GtkWidget * window;
  GtkWidget * vbox;
  struct etpan_toolbar * toolbar;
  GtkWidget * table;
  struct etpan_gtk_tree_data_source account_datasource;
  etpan_gtk_tree_model * treemodel;
  GtkWidget * account_label;
  GtkWidget * account_combo;
  GtkWidget * to_label;
  struct etpan_completion * to_completion;
  GtkWidget * subject_label;
  GtkWidget * subject_entry;
  GtkWidget * cc_label;
  struct etpan_completion * cc_completion;
  GtkWidget * bcc_label;
  struct etpan_completion * bcc_completion;
  GtkWidget * reply_to_label;
  struct etpan_completion * reply_to_completion;
  GtkWidget * newsgroups_label;
  GtkWidget * newsgroups_entry;
  GtkWidget * scrolledwindow;
  GtkWidget * textview;
  GtkTextBuffer * textbuffer;
  gulong delete_signal_id;
  gulong key_press_signal_id;
  gulong mark_set_signal_id;
  gulong account_changed_signal_id;
  carray * attach_list;
  unsigned int attach_index;
  carray * references;
  int moving_mark;
  struct etpan_status_bar * status_bar;
  
  struct etpan_message_composer * composer;
  int additional_header_shown;
  
#if 0
  unsigned int outbox_count;
  carray * error_list;
#endif
  struct etpan_error * error;
  
  int compose_type;
  struct etpan_message * reference_msg;
};

#endif
