#ifndef ETPAN_MESSAGE_COMPOSER_WINDOW_H

#define ETPAN_MESSAGE_COMPOSER_WINDOW_H

#include "etpan-message-composer-window-types.h"
#include "etpan-backend.h"

struct etpan_message_composer_window * etpan_message_composer_window_new(void);
void etpan_message_composer_window_free(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_setup(struct etpan_message_composer_window * composer_window);
void etpan_message_composer_window_unsetup(struct etpan_message_composer_window * composer_window);

GtkWidget *
etpan_message_composer_window_get_main_widget(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_set_references(struct etpan_message_composer_window * composer_window, carray * references);

carray * etpan_message_composer_window_get_references(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_set_composer(struct etpan_message_composer_window * composer_window, struct etpan_message_composer * composer);

void etpan_message_composer_window_reply(struct etpan_message_composer_window * composer_window, struct etpan_message * msg);

void etpan_message_composer_window_reply_cancel(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_forward(struct etpan_message_composer_window * composer_window, struct etpan_message * msg);

void etpan_message_composer_window_forward_cancel(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_set_account(struct etpan_message_composer_window * composer_window, struct etpan_account * account);

struct etpan_error * etpan_message_composer_window_get_error(struct etpan_message_composer_window * composer_window);

void etpan_message_composer_window_show(struct etpan_message_composer_window * composer_window);

#endif
