#ifndef ETPAN_MESSAGE_LIST_TYPES_H

#define ETPAN_MESSAGE_LIST_TYPES_H

#include <gtk/gtk.h>
#include <libetpan/libetpan.h>
#include "etpan-folder-list-types.h"
#include "etpan-backend.h"
#include "etpan-search-field-types.h"

#define ETPAN_MESSAGE_LIST_SELECTIONCHANGED_SIGNAL \
  "org.etpan.message-list.selection-changed"
#define ETPAN_MESSAGE_LIST_FOLDERCHECK_SIGNAL \
  "org.etpan.message-list.folder-check"
#define ETPAN_MESSAGE_LIST_NEXT_SIGNAL \
  "org.etpan.message-list.next"
#define ETPAN_MESSAGE_LIST_SEARCH_DONE_SIGNAL \
  "org.etpan.message-list.search-done"

#define ETPAN_MESSAGE_LIST_DRAG_MSGLIST_NAME \
  "org.etpan.message-list.drag-msg-list"

struct etpan_message_list {
  GtkWidget * main_widget;
  GtkWidget * search_label;
  GtkWidget * scrolledwindow;
  GtkWidget * treeview;
  etpan_gtk_tree_model * msglist_model;
  struct etpan_gtk_tree_data_source msglist_datasource;
  struct etpan_message_tree * msg_tree;
  struct etpan_folder * folder;
  struct etpan_thread_op * fetch_list_op;
  struct etpan_msg_list_fetch * fetcher;
  char * current_selection;
  gulong msg_selected_signal_id;
  gulong button_press_signal_id;
  gulong button_release_signal_id;
  gulong motion_signal_id;
  gulong popup_menu_signal_id;
  gulong keypress_signal_id;
  gulong size_changed_signal_id;
  gulong test_collapse_row_signal_id;
  gulong expand_row_signal_id;
  gulong selection_changed_signal_id;
  int expanding;
  struct etpan_folder_list * folder_list;
  struct etpan_search_field * search_field;
  gulong update_timer_id;
  gulong check_timer_id;
  int check_timer_set;
  unsigned int selected_thread_count;
  int reloading;
  
  int changing;
  int current_from_size;
  int current_subject_size;
  int current_date_size;
  GtkTreeViewColumn * col_unread;
  GtkTreeViewColumn * col_from;
  GtkTreeViewColumn * col_subject;
  GtkTreeViewColumn * col_date;
  time_t current_time;
  
  struct etpan_contextual_menu * popup_menu;
  struct etpan_contextual_menu * popup_submenu;
  
  chash * selected_thread;
  
  /* search */
  int search_filter_type;
  int search_filter_set;
  char * search_filter_text;
  int searching;
  int indexing;
  int filtering_search_result;
  int search_has_progress;
  
  /* drag and drop */
  gulong drag_data_get_signal_id;
  gulong drag_begin_signal_id;
  gulong drag_end_signal_id;
  gulong drag_row_expanded_signal_id;
  gulong drag_row_collapsed_signal_id;
  int drag_may_start;
  int drag_expanded;
  gdouble drag_may_start_x;
  gdouble drag_may_start_y;
  GdkDragContext * drag_context;
  int drag_started;
  int drag_timer_set;
  gulong drag_timer_id;
  gulong drag_button_press_signal_id;
  gulong drag_button_release_signal_id;
  gulong drag_motion_signal_id;
  
  int reaching_message;
  
  struct etpan_folder_view * folder_view;
  
  int has_user_action;
};

#endif
