#ifndef ETPAN_MESSAGE_LIST_H

#define ETPAN_MESSAGE_LIST_H

#include "etpan-message-list-types.h"

#include "etpan-folder-list-types.h"
#include "etpan-message-composer-window-types.h"
#include "etpan-tabbed-message-list-types.h"

struct etpan_message_list * etpan_message_list_new(void);
void etpan_message_list_free(struct etpan_message_list * msg_list);

GtkWidget * etpan_message_list_get_main_widget(struct etpan_message_list *
    msg_list);

void etpan_message_list_set_folder(struct etpan_message_list * msg_list,
    struct etpan_folder * folder);

void etpan_message_list_set_activated(struct etpan_message_list * msg_list,
    struct etpan_tabbed_message_list * tabbed, int value);

#if 0
void etpan_message_list_update_list(struct etpan_message_list * msg_list);
#endif

void etpan_message_list_setup(struct etpan_message_list * msg_list);
void etpan_message_list_unsetup(struct etpan_message_list * msg_list);

struct etpan_message *
etpan_message_list_get_message(struct etpan_message_list * msg_list,
    char * uid);

void etpan_message_list_set_folder_list(struct etpan_message_list * msg_list,
    struct etpan_folder_list * folder_list);
void etpan_message_list_set_search_field(struct etpan_message_list * msg_list,
    struct etpan_search_field * search_field);

#if 0
void etpan_message_list_refresh(struct etpan_message_list * msg_list);
#endif

void etpan_message_list_reply(struct etpan_message_list * msg_list,
    struct etpan_message_composer_window * composer_window);

void etpan_message_list_forward(struct etpan_message_list * msg_list,
    struct etpan_message_composer_window * composer_window);

void etpan_message_list_delete(struct etpan_message_list * msg_list);

void etpan_message_list_mark_as_read(struct etpan_message_list * msg_list);
void etpan_message_list_mark_as_flagged(struct etpan_message_list * msg_list);

void etpan_message_list_mark_color(struct etpan_message_list * msg_list,
    char * color);

GtkTreeViewColumn *
etpan_message_list_get_col_unread(struct etpan_message_list * msg_list);

GtkTreeViewColumn *
etpan_message_list_get_col_from(struct etpan_message_list * msg_list);

GtkTreeViewColumn *
etpan_message_list_get_col_subject(struct etpan_message_list * msg_list);

GtkTreeViewColumn *
etpan_message_list_get_col_date(struct etpan_message_list * msg_list);

void etpan_message_list_next_unread(struct etpan_message_list * msg_list);

void etpan_message_list_search(struct etpan_message_list * msg_list,
    int filter_type, const char * text);

void etpan_message_list_move(struct etpan_message_list * msg_list,
    struct etpan_folder * folder);

void etpan_message_list_copy(struct etpan_message_list * msg_list,
    struct etpan_folder * folder);

#endif
