#ifndef ETPAN_MESSAGE_VIEW_TYPES_H

#define ETPAN_MESSAGE_VIEW_TYPES_H

#include <gtk/gtk.h>
#include <libetpan/libetpan.h>
#include "etpan-status-bar-types.h"
#include "etpan-message-list-types.h"
#include "etpan-contextual-menu-types.h"

#define ETPAN_MESSAGE_VIEW_FLAGSCHANGED_SIGNAL \
  "org.etpan.message-list.flags-changed"

enum {
  ETPAN_MESSAGE_VIEW_MODE_NORMAL,
  ETPAN_MESSAGE_VIEW_MODE_SOURCE,
};

struct etpan_message_view {
  GtkWidget * scrolledwindow;
  GtkWidget * textview;
  GtkTextBuffer * textbuffer;
  GtkWidget * separator;
  struct etpan_message * message;
  
  int mode;
  struct etpan_message_fetcher * fetcher;
  int fetcher_mode;
  
  struct etpan_status_bar * status_bar;
  struct etpan_message_list * msg_list;
  
  int parts_fetched;
  carray * parts_list;
  carray * links_list;
  gulong motion_signal_id;
  gulong button_signal_id;
  gulong keypress_signal_id;
  gulong resize_signal_id;
  
  struct etpan_contextual_menu * address_popup_menu;
  void * current_address;
  
  struct etpan_contextual_menu * part_popup_menu;
  void * current_part;
  
  carray * save_op_list;
};

#endif
