#include "etpan-progress.h"

#include <stdlib.h>
#include "etpan-backend.h"
#include "etpan-icon-manager.h"

#define PULSE_STEP 0.3
#define ANIMATION_INTERVAL 100

#define PROGRESS_ANIM_COUNT 10

static void progress_init(struct etpan_progress * progress)
{
  progress->progress_anim = malloc(PROGRESS_ANIM_COUNT *
      sizeof(* progress->progress_anim));
  if (progress->progress_anim == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
#define ICON(num) \
  etpan_icon_manager_get_pixbuf(etpan_icon_manager_get_default(), "progress-" num)
  
  progress->progress_anim[0] = ICON("0");
  progress->progress_anim[1] = ICON("1");
  progress->progress_anim[2] = ICON("2");
  progress->progress_anim[3] = ICON("3");
  progress->progress_anim[4] = ICON("4");
  progress->progress_anim[5] = ICON("5");
  progress->progress_anim[6] = ICON("4");
  progress->progress_anim[7] = ICON("3");
  progress->progress_anim[8] = ICON("2");
  progress->progress_anim[9] = ICON("1");
#undef ICON
}

struct etpan_progress * etpan_progress_new(void)
{
  GtkWidget * image;
  struct etpan_progress * progress;
  
  progress = malloc(sizeof(* progress));
  if (progress == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  image = gtk_image_new();
  gtk_widget_show(image);
  
  progress->image = image;
  progress->animating = 0;
  
  progress_init(progress);
  
  return progress;
}

void etpan_progress_free(struct etpan_progress * progress)
{
  gtk_widget_destroy(progress->image);
  
  free(progress->progress_anim);
  free(progress);
}

GtkWidget * etpan_progress_get_main_widget(struct etpan_progress * progress)
{
  return progress->image;
}

static gboolean do_animation(gpointer data)
{
  struct etpan_progress * progress;
  
  progress = data;
  
  gtk_image_set_from_pixbuf(GTK_IMAGE(progress->image),
      progress->progress_anim[progress->current]);
  progress->current ++;
  progress->current %= PROGRESS_ANIM_COUNT;
  
  return TRUE;
}

void etpan_progress_start_animation(struct etpan_progress * progress)
{
  progress->animating ++;
  
#if 0
  ETPAN_PROGRESS_LOG("start progress %i", progress->animating);
#endif
  
  if (progress->animating > 1)
    return;
  
  progress->current = 0;
  
  progress->animation_id = g_timeout_add(ANIMATION_INTERVAL,
      (GSourceFunc) do_animation, (gpointer) progress);
}

void etpan_progress_stop_animation(struct etpan_progress * progress)
{
  if (progress->animating == 0)
    return;
  
  progress->animating --;
  
#if 0
  ETPAN_PROGRESS_LOG("stop progress %i", progress->animating);
#endif
  
  if (progress->animating > 0)
    return;
  
  gtk_image_set_from_pixbuf(GTK_IMAGE(progress->image), NULL);
  
  g_source_remove(progress->animation_id);
}

void etpan_progress_setup(struct etpan_progress * progress)
{
  (void) progress;
}

void etpan_progress_unsetup(struct etpan_progress * progress)
{
  while (progress->animating > 0)
    etpan_progress_stop_animation(progress);
}
