#ifndef ETPAN_SEARCH_FIELD_H

#define ETPAN_SEARCH_FIELD_H

#include "etpan-search-field-types.h"

struct etpan_search_field * etpan_search_field_new(void);
void etpan_search_field_free(struct etpan_search_field * search_field);

void etpan_search_field_setup(struct etpan_search_field * search_field);
void etpan_search_field_unsetup(struct etpan_search_field * search_field);

GtkWidget *
etpan_search_field_get_main_widget(struct etpan_search_field * search_field);

GtkWidget *
etpan_search_field_get_entry(struct etpan_search_field * search_field);

const char *
etpan_search_field_get_value(struct etpan_search_field * search_field);

void etpan_search_field_set_search_type(struct etpan_search_field * search_field,
    int search_type);

int etpan_search_field_get_search_type(struct etpan_search_field * search_field);

void etpan_search_field_start_animation(struct etpan_search_field * search_field);
void etpan_search_field_stop_animation(struct etpan_search_field * search_field);

#endif
