#include "etpan-status-bar.h"

#include <stdlib.h>
#include "etpan-backend.h"
#include "etpan-icon-manager.h"
#include "etpan-log.h"

#define PULSE_STEP 0.3
#define ANIMATION_INTERVAL 100

#define STATUS_BAR_ANIM_COUNT 10

static void status_bar_init(struct etpan_status_bar * status_bar)
{
  status_bar->status_bar_anim = malloc(STATUS_BAR_ANIM_COUNT *
      sizeof(* status_bar->status_bar_anim));
  if (status_bar->status_bar_anim == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
#define ICON(num) \
  etpan_icon_manager_get_pixbuf(etpan_icon_manager_get_default(), "progress-" num)
  
  status_bar->status_bar_anim[0] = ICON("0");
  status_bar->status_bar_anim[1] = ICON("1");
  status_bar->status_bar_anim[2] = ICON("2");
  status_bar->status_bar_anim[3] = ICON("3");
  status_bar->status_bar_anim[4] = ICON("4");
  status_bar->status_bar_anim[5] = ICON("5");
  status_bar->status_bar_anim[6] = ICON("4");
  status_bar->status_bar_anim[7] = ICON("3");
  status_bar->status_bar_anim[8] = ICON("2");
  status_bar->status_bar_anim[9] = ICON("1");
#undef ICON
}

struct etpan_status_bar * etpan_status_bar_new(void)
{
  GtkWidget * status_bar_widget;
  GtkWidget * progress;
  struct etpan_status_bar * status_bar;
  
  status_bar = malloc(sizeof(* status_bar));
  if (status_bar == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  status_bar_widget = gtk_statusbar_new();
  gtk_widget_show(status_bar_widget);
  
#if 0
  status_bar_bar = gtk_status_bar_bar_new();
  gtk_status_bar_bar_set_orientation(GTK_STATUS_BAR_BAR(status_bar_bar),
      GTK_STATUS_BAR_LEFT_TO_RIGHT);
  gtk_widget_show(status_bar_bar);
  gtk_box_pack_start(GTK_BOX(status_bar), status_bar_bar, FALSE, TRUE, 0);
#endif
  progress = gtk_image_new();
  gtk_widget_show(progress);
  gtk_box_pack_start(GTK_BOX(status_bar_widget), progress, FALSE, TRUE, 0);
  
  status_bar->status_bar = status_bar_widget;
  status_bar->progress = progress;
  status_bar->animating = 0;
  
  status_bar_init(status_bar);
  
  return status_bar;
}

void etpan_status_bar_free(struct etpan_status_bar * status_bar)
{
  free(status_bar->status_bar_anim);
  gtk_widget_destroy(status_bar->progress);
  gtk_widget_destroy(status_bar->status_bar);
  
  free(status_bar);
}

GtkWidget * etpan_status_bar_get_main_widget(struct etpan_status_bar * status_bar)
{
  return status_bar->status_bar;
}

static gboolean do_animation(gpointer data)
{
  struct etpan_status_bar * status_bar;
  
  status_bar = data;
  
#if 0
  gtk_status_bar_bar_pulse(GTK_STATUS_BAR_BAR(status_bar->status_bar_bar));
#endif
  gtk_image_set_from_pixbuf(GTK_IMAGE(status_bar->progress),
      status_bar->status_bar_anim[status_bar->current_status_bar]);
  gtk_widget_hide(status_bar->progress);
  gtk_widget_show(status_bar->progress);
  status_bar->current_status_bar ++;
  status_bar->current_status_bar %= STATUS_BAR_ANIM_COUNT;
  
  return TRUE;
}

void etpan_status_bar_start_animation(struct etpan_status_bar * status_bar)
{
  status_bar->animating ++;
  
  ETPAN_STATUS_BAR_LOG("start status_bar %i", status_bar->animating);
  
  if (status_bar->animating > 1)
    return;
  
  status_bar->current_status_bar = 0;
#if 0
  gtk_status_bar_bar_set_bar_style(GTK_STATUS_BAR_BAR(status_bar->status_bar_bar),
      GTK_STATUS_BAR_CONTINUOUS);
  gtk_status_bar_bar_set_pulse_step(GTK_STATUS_BAR_BAR(status_bar->status_bar_bar),
      PULSE_STEP);
#endif
  
  status_bar->animation_id = g_timeout_add(ANIMATION_INTERVAL,
      (GSourceFunc) do_animation, (gpointer) status_bar);
}

void etpan_status_bar_stop_animation(struct etpan_status_bar * status_bar)
{
  if (status_bar->animating == 0)
    return;
  
  status_bar->animating --;
  
  ETPAN_STATUS_BAR_LOG("stop status_bar %i", status_bar->animating);
  
  if (status_bar->animating > 0)
    return;
  
#if 0
  gtk_status_bar_bar_set_fraction(GTK_STATUS_BAR_BAR(status_bar->status_bar_bar), 0);
#endif
  gtk_image_set_from_pixbuf(GTK_IMAGE(status_bar->progress), NULL);
  
  g_source_remove(status_bar->animation_id);
}

void etpan_status_bar_setup(struct etpan_status_bar * status_bar)
{
  (void) status_bar;
}

void etpan_status_bar_unsetup(struct etpan_status_bar * status_bar)
{
  while (status_bar->animating > 0)
    etpan_status_bar_stop_animation(status_bar);
}
