#ifndef ETPAN_TABBED_MESSAGE_LIST_H

#define ETPAN_TABBED_MESSAGE_LIST_H

#include "etpan-tabbed-message-list-types.h"
#include "etpan-folder-list-types.h"

struct etpan_tabbed_message_list * etpan_tabbed_message_list_new(void);
void etpan_tabbed_message_list_free(struct etpan_tabbed_message_list *
    tabbed);

GtkWidget * etpan_tabbed_message_list_get_main_widget(struct
    etpan_tabbed_message_list * tabbed);

void etpan_tabbed_message_list_setup(struct etpan_tabbed_message_list *
    tabbed);
void etpan_tabbed_message_list_unsetup(struct etpan_tabbed_message_list *
    tabbed);

void etpan_tabbed_message_list_add_page(struct etpan_tabbed_message_list *
    tabbed, unsigned int * p_index);

void etpan_tabbed_message_list_close_page(struct etpan_tabbed_message_list *
    tabbed, unsigned int index);

int etpan_tabbed_message_list_get_current_page(struct
    etpan_tabbed_message_list * tabbed);

void etpan_tabbed_message_list_set_current_page(struct
    etpan_tabbed_message_list * tabbed, unsigned int index);

unsigned int
etpan_tabbed_message_list_get_count(struct etpan_tabbed_message_list *
    tabbed);

struct etpan_message_list *
etpan_tabbed_message_list_get_current_message_list(struct
    etpan_tabbed_message_list * tabbed);

struct etpan_message_list * etpan_tabbed_message_list_get_message_list(struct
    etpan_tabbed_message_list * tabbed, unsigned int index);

void etpan_tabbed_message_list_set_folder_list(struct
    etpan_tabbed_message_list * tabbed,
    struct etpan_folder_list * folder_list);

void etpan_tabbed_message_list_set_bookmark_view(struct
    etpan_tabbed_message_list * tabbed,
    struct etpan_bookmark_view * bookmark_view);

void etpan_tabbed_message_list_set_status_bar(struct
    etpan_tabbed_message_list * tabbed,
    struct etpan_status_bar * status_bar);

void etpan_tabbed_message_list_set_search_field(struct
    etpan_tabbed_message_list * tabbed,
    struct etpan_search_field * search_field);

void etpan_tabbed_message_list_close_all(struct
    etpan_tabbed_message_list * tabbed);

#endif
