#ifndef ETPAN_TOOLBAR_H

#define ETPAN_TOOLBAR_H

#include "etpan-toolbar-types.h"
#include "etpan-contextual-menu-types.h"

struct etpan_toolbar * etpan_toolbar_new(void);
void etpan_toolbar_free(struct etpan_toolbar * toolbar);

GtkWidget * etpan_toolbar_get_main_widget(struct etpan_toolbar *
    toolbar);

void etpan_toolbar_add_item(struct etpan_toolbar * toolbar,
    char * label, GtkWidget * image);

void etpan_toolbar_replace_item(struct etpan_toolbar * toolbar,
    int position, char * label, GtkWidget * image);

void etpan_toolbar_add_separator(struct etpan_toolbar * toolbar);

void etpan_toolbar_add_widget(struct etpan_toolbar * toolbar,
    GtkWidget * widget);

void etpan_toolbar_add_expander(struct etpan_toolbar * toolbar);
void etpan_toolbar_add_space(struct etpan_toolbar * toolbar);

void etpan_toolbar_clear(struct etpan_toolbar * toolbar);

GtkWidget * etpan_toolbar_get_item_at_position(struct etpan_toolbar * toolbar,
    int position);

void etpan_toolbar_add_item_menu(struct etpan_toolbar * toolbar,
    char * label, GtkWidget * image,
    struct etpan_contextual_menu * menu);

#endif
