#ifndef ETPAN_UI_CONFIG_H

#define ETPAN_UI_CONFIG_H

#include "etpan-ui-config-types.h"
#include "etpan-backend.h"
#include <gtk/gtk.h>

struct etpan_ui_config * etpan_ui_config_new(void);
void etpan_ui_config_free(struct etpan_ui_config * config);

void etpan_ui_config_set_default(struct etpan_ui_config * config);
struct etpan_ui_config * etpan_ui_config_get_default(void);

struct etpan_error * etpan_ui_config_read(struct etpan_ui_config * config,
    char * filename);

struct etpan_error * etpan_ui_config_read_default(void);

struct etpan_error * etpan_ui_config_save(struct etpan_ui_config * config,
    char * filename);
struct etpan_error * etpan_ui_config_save_default(void);

int etpan_ui_config_get_slider(struct etpan_ui_config * config, char * name,
    int * p_slider);

int etpan_ui_config_get_window(struct etpan_ui_config * config, char * name,
    int * p_left, int * p_top, int * p_width, int * p_height);

int etpan_ui_config_get_column(struct etpan_ui_config * config, char * name,
    int * p_column);

void etpan_ui_config_set_font_message(struct etpan_ui_config * ui_config,
    char * font_message);
void etpan_ui_config_set_font_list(struct etpan_ui_config * ui_config,
    char * font_list);
void etpan_ui_config_set_font_other(struct etpan_ui_config * ui_config,
    char * font_other);

char * etpan_ui_config_get_font_message(struct etpan_ui_config * ui_config);
char * etpan_ui_config_get_font_list(struct etpan_ui_config * ui_config);
char * etpan_ui_config_get_font_other(struct etpan_ui_config * ui_config);

void etpan_ui_set_from_window(struct etpan_ui_config * config,
    char * name,
    GtkWidget * window);
void etpan_ui_window_set(struct etpan_ui_config * config,
    char * name,
    GtkWidget * window);

void etpan_ui_set_from_slider(struct etpan_ui_config * config,
    char * name,
    GtkWidget * paned);

void etpan_ui_slider_set(struct etpan_ui_config * config,
    char * name,
    GtkWidget * paned);

void etpan_ui_set_from_column(struct etpan_ui_config * config,
    char * name, GtkWidget * treeview, int n);
void etpan_ui_column_set(struct etpan_ui_config * config,
    char * name, GtkWidget * treeview, int n);

#endif
